/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class DisplayItemCommand
extends AbstractCommand
implements Listener {
    public final HashSet<UUID> protectedEntities = new HashSet();

    public DisplayItemCommand() {
        this.setName("displayitem");
        this.setSyntax("displayitem [<item>] [<location>] (duration:<value>)");
        this.setRequiredArguments(2, 3);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(DurationTag.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(ItemTag.class) && !scriptEntry.hasObject("item")) {
                scriptEntry.addObject("item", arg.asType(ItemTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify an item to display.");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new DurationTag(60));
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.protectedEntities.contains(event.getEntity().getUniqueId()) || this.protectedEntities.contains(event.getTarget().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemInventoryPickup(InventoryPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemEntityPickup(EntityPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ItemTag item = (ItemTag)scriptEntry.getObjectTag("item");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), item.debug() + duration.debug() + location.debug());
        }
        final Item dropped = location.getWorld().dropItem((Location)location.getBlockLocation().clone().add(0.5, 1.5, 0.5), item.getItemStack());
        dropped.setVelocity(dropped.getVelocity().multiply(0));
        dropped.setPickupDelay(duration.getTicksAsInt() + 1000);
        dropped.setTicksLived(duration.getTicksAsInt() + 1000);
        if (!dropped.isValid()) {
            Debug.echoDebug((Debuggable)scriptEntry, "Item failed to spawned (likely blocked by some plugin).");
            return;
        }
        final UUID itemUUID = dropped.getUniqueId();
        this.protectedEntities.add(itemUUID);
        scriptEntry.addObject("dropped", new EntityTag((Entity)dropped));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (dropped.isValid() && !dropped.isDead()) {
                    dropped.remove();
                    DisplayItemCommand.this.protectedEntities.remove(itemUUID);
                }
            }
        }, duration.getTicks());
    }
}

