/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;

public class ServerGeneratesExceptionScriptEvent
extends ScriptEvent {
    public static ServerGeneratesExceptionScriptEvent instance;
    public Throwable exception;
    public ScriptQueue queue;
    public String fullTrace;
    public static boolean cancelledTracker;

    public ServerGeneratesExceptionScriptEvent() {
        instance = this;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.queue != null && this.queue.getLastEntryExecuted() != null) {
            return this.queue.getLastEntryExecuted().entryData;
        }
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("message")) {
            return new ElementTag(this.exception.getMessage());
        }
        if (name.equals("full_trace")) {
            return new ElementTag(this.fullTrace);
        }
        if (name.equals("type")) {
            return new ElementTag(this.exception.getClass().getSimpleName());
        }
        if (name.equals("queue") && this.queue != null) {
            return new QueueTag(this.queue);
        }
        return super.getContext(name);
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("server generates exception");
    }

    @Override
    public void cancellationChanged() {
        cancelledTracker = this.cancelled;
        super.cancellationChanged();
    }

    @Override
    public String getName() {
        return "ServerGeneratesException";
    }

    public boolean handle(Throwable ex, String trace, ScriptQueue queue) {
        this.queue = queue;
        this.fullTrace = trace;
        this.exception = ex;
        cancelledTracker = false;
        this.fire();
        return cancelledTracker;
    }

    static {
        cancelledTracker = false;
    }
}

