/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class DefineCommand
extends AbstractCommand {
    public DefineCommand() {
        this.setName("define");
        this.setSyntax("define [<id>](:<action>)[:<value>]");
        this.setRequiredArguments(1, 2);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("definition")) {
                if (CoreUtilities.contains(arg.getRawValue(), ':')) {
                    DefinitionActionProvider provider = new DefinitionActionProvider();
                    provider.queue = scriptEntry.getResidingQueue();
                    scriptEntry.addObject("action", DataActionHelper.parse((ActionableDataProvider)provider, arg, scriptEntry.context));
                    continue;
                }
                scriptEntry.addObject("definition", new ElementTag(CoreUtilities.toLowerCase(arg.getValue())));
                continue;
            }
            if (!scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", arg.object instanceof ElementTag ? new ElementTag(arg.getRawValue()) : arg.object);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!(scriptEntry.hasObject("definition") && scriptEntry.hasObject("value") || scriptEntry.hasObject("action"))) {
            throw new InvalidArgumentsException("Must specify a definition and value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag definition = scriptEntry.getElement("definition");
        Object value = scriptEntry.getObjectTag("value");
        ElementTag remove = scriptEntry.getElement("remove");
        DataAction action = (DataAction)scriptEntry.getObject("action");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("queue", scriptEntry.getResidingQueue().id) + (definition == null ? "" : definition.debug()) + (value == null ? "" : value.debug()) + (action == null ? "" : action.debug()) + (remove != null ? remove.debug() : ""));
        }
        if (action != null) {
            action.execute(scriptEntry.getContext());
            return;
        }
        scriptEntry.getResidingQueue().addDefinition(definition.asString(), value.duplicate());
    }

    public static class DefinitionActionProvider
    extends ActionableDataProvider {
        public ScriptQueue queue;

        @Override
        public ObjectTag getValueAt(String keyName) {
            return this.queue.getDefinitionObject(keyName);
        }

        @Override
        public void setValueAt(String keyName, ObjectTag value) {
            this.queue.addDefinition(keyName, value);
        }
    }
}

