/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.containers.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomScriptContainer
extends ScriptContainer {
    public HashMap<String, String> defaultVars = new HashMap();
    public String inherit = null;

    public HashMap<String, ObjectTag> getVars() {
        Object sc;
        HashMap<String, ObjectTag> vars = this.inherit != null ? ((sc = ScriptRegistry.getScriptContainer(this.inherit)) instanceof CustomScriptContainer ? ((CustomScriptContainer)sc).getVars() : new HashMap()) : new HashMap();
        for (Map.Entry<String, String> str : this.defaultVars.entrySet()) {
            vars.put(str.getKey(), new ElementTag(str.getValue()));
        }
        return vars;
    }

    public CustomScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        for (StringHolder str : this.getConfigurationSection("").getKeys(false)) {
            if (str.low.equals("inherit")) {
                this.inherit = this.getString(str.str);
                continue;
            }
            if (str.low.equals("type") || str.low.equals("tags") || str.low.equals("mechanisms") || str.low.equals("speed") || str.low.equals("debug") || configurationSection.getConfigurationSection(str.str) != null) continue;
            this.defaultVars.put(str.low, this.getString(str.str));
        }
    }

    public boolean hasPath(String path) {
        CustomScriptContainer csc = this;
        while (csc != null) {
            if (csc.contains(path)) {
                return true;
            }
            csc = ScriptRegistry.getScriptContainerAs(csc.inherit, CustomScriptContainer.class);
        }
        return false;
    }

    public ListTag runTagScript(String path, ObjectTag val, CustomObjectTag obj, ScriptEntryData data) {
        CustomScriptContainer csc = this;
        while (csc != null) {
            if (csc.contains("tags." + path)) {
                Debug.echoDebug((Debuggable)this, "[CustomObject] Calculating tag: " + path + " for " + csc.getName());
                InstantQueue queue = new InstantQueue("TAG_" + csc.getName() + "_" + path + "__");
                List<ScriptEntry> listOfEntries = csc.getEntries(data, "tags." + path);
                CustomScriptContextSource cscs = new CustomScriptContextSource();
                cscs.obj = obj;
                cscs.value = val;
                queue.setContextSource(cscs);
                queue.addEntries(listOfEntries);
                queue.start();
                return queue.determinations;
            }
            Debug.echoDebug((Debuggable)this, "[CustomObject] Grabbing parent of " + csc.getName());
            csc = ScriptRegistry.getScriptContainerAs(csc.inherit, CustomScriptContainer.class);
        }
        Debug.echoDebug((Debuggable)this, "Unable to find tag handler for " + path + " for " + this.getName());
        return null;
    }

    public ListTag runMechScript(String path, CustomObjectTag obj, ObjectTag value) {
        CustomScriptContainer csc = this;
        while (csc != null) {
            if (csc.contains("mechanisms." + path)) {
                InstantQueue queue = new InstantQueue("MECH_" + csc.getName() + "_" + path + "__");
                List<ScriptEntry> listOfEntries = csc.getEntries(DenizenCore.getImplementation().getEmptyScriptEntryData(), "mechanisms." + path);
                CustomScriptContextSource cscs = new CustomScriptContextSource();
                cscs.obj = obj;
                cscs.value = value;
                queue.setContextSource(cscs);
                queue.addEntries(listOfEntries);
                queue.start();
                return queue.determinations;
            }
            csc = ScriptRegistry.getScriptContainerAs(csc.inherit, CustomScriptContainer.class);
        }
        return null;
    }

    public static class CustomScriptContextSource
    implements ContextSource {
        public CustomObjectTag obj;
        public ObjectTag value;

        @Override
        public ObjectTag getContext(String name) {
            if (name.equals("this")) {
                return this.obj;
            }
            if (name.equals("value")) {
                return this.value;
            }
            return null;
        }
    }
}

