/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.tags.core.BiomeTagBase;
import com.denizenscript.denizen.tags.core.ChunkTagBase;
import com.denizenscript.denizen.tags.core.ColorTagBase;
import com.denizenscript.denizen.tags.core.CuboidTagBase;
import com.denizenscript.denizen.tags.core.EllipsoidTagBase;
import com.denizenscript.denizen.tags.core.EntityTagBase;
import com.denizenscript.denizen.tags.core.InventoryTagBase;
import com.denizenscript.denizen.tags.core.ItemTagBase;
import com.denizenscript.denizen.tags.core.LocationTagBase;
import com.denizenscript.denizen.tags.core.MaterialTagBase;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.tags.core.ParseTagBase;
import com.denizenscript.denizen.tags.core.PlayerTagBase;
import com.denizenscript.denizen.tags.core.PluginTagBase;
import com.denizenscript.denizen.tags.core.PolygonTagBase;
import com.denizenscript.denizen.tags.core.ServerTagBase;
import com.denizenscript.denizen.tags.core.TextTagBase;
import com.denizenscript.denizen.tags.core.TradeTagBase;
import com.denizenscript.denizen.tags.core.WorldTagBase;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public class CommonRegistries {
    public static void registerMainTagHandlers() {
        new BiomeTagBase();
        new ChunkTagBase();
        new ColorTagBase();
        new CuboidTagBase();
        new EllipsoidTagBase();
        new EntityTagBase();
        new InventoryTagBase();
        new ItemTagBase();
        new LocationTagBase();
        new MaterialTagBase();
        if (Depends.citizens != null) {
            new NPCTagBase();
        }
        new PlayerTagBase();
        new PluginTagBase();
        new PolygonTagBase();
        new TradeTagBase();
        new WorldTagBase();
        new ServerTagBase();
        new TextTagBase();
        new ParseTagBase();
    }

    public static void registerMainObjects() {
        ObjectFetcher.registerWithObjectFetcher(BiomeTag.class, BiomeTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ChunkTag.class, ChunkTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ColorTag.class, ColorTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(CuboidTag.class, CuboidTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(EllipsoidTag.class, EllipsoidTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(EntityTag.class, EntityTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(InventoryTag.class, InventoryTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ItemTag.class, ItemTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(LocationTag.class, LocationTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(MaterialTag.class, MaterialTag.tagProcessor);
        if (Depends.citizens != null) {
            ObjectFetcher.registerWithObjectFetcher(NPCTag.class, NPCTag.tagProcessor);
        }
        ObjectFetcher.registerWithObjectFetcher(PlayerTag.class, PlayerTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(PluginTag.class, PluginTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(PolygonTag.class, PolygonTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(TradeTag.class, TradeTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(WorldTag.class, WorldTag.tagProcessor);
        StringBuilder debug = new StringBuilder(256);
        for (ObjectFetcher.ObjectType<? extends ObjectTag> objectType : ObjectFetcher.objectsByPrefix.values()) {
            debug.append(objectType.clazz.getSimpleName()).append(" as ").append(objectType.prefix).append(", ");
        }
        CoreUtilities.registerTypeAsNoOtherTypeCode(BiomeTag.class, "b");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ChunkTag.class, "ch");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ColorTag.class, "co");
        CoreUtilities.registerTypeAsNoOtherTypeCode(CuboidTag.class, "cu");
        CoreUtilities.registerTypeAsNoOtherTypeCode(EllipsoidTag.class, "ellipsoid");
        CoreUtilities.typeCheckers.put(EntityTag.class, new CoreUtilities.TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                if (inp == null) {
                    return false;
                }
                Class<? extends ObjectTag> inpType = inp.getObjectTagClass();
                if (inpType == EntityTag.class || inpType == PlayerTag.class || inpType == NPCTag.class) {
                    return true;
                }
                if (inpType == ElementTag.class) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("e") || code.equals("p") || code.equals("n") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            }
        });
        CoreUtilities.registerTypeAsNoOtherTypeCode(InventoryTag.class, "in");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ItemTag.class, "i");
        CoreUtilities.registerTypeAsNoOtherTypeCode(LocationTag.class, "l");
        CoreUtilities.registerTypeAsNoOtherTypeCode(MaterialTag.class, "m");
        CoreUtilities.registerTypeAsNoOtherTypeCode(NPCTag.class, "n");
        CoreUtilities.registerTypeAsNoOtherTypeCode(PlayerTag.class, "p");
        CoreUtilities.registerTypeAsNoOtherTypeCode(PluginTag.class, "pl");
        CoreUtilities.registerTypeAsNoOtherTypeCode(PolygonTag.class, "polygon");
        CoreUtilities.registerTypeAsNoOtherTypeCode(TradeTag.class, "trade");
        CoreUtilities.registerTypeAsNoOtherTypeCode(WorldTag.class, "w");
        Debug.echoApproval("Loaded core object types: [" + debug.substring(0, debug.length() - 2) + "]");
    }
}

