/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DataPersistenceHelper {
    public static final DenizenObjectType PERSISTER_TYPE = new DenizenObjectType();

    public static void removeDenizenKey(PersistentDataHolder holder, String keyName) {
        holder.getPersistentDataContainer().remove(new NamespacedKey((Plugin)Denizen.getInstance(), keyName));
    }

    public static void setDenizenKey(PersistentDataHolder holder, String keyName, ObjectTag keyValue) {
        holder.getPersistentDataContainer().set(new NamespacedKey((Plugin)Denizen.getInstance(), keyName), (PersistentDataType)PERSISTER_TYPE, (Object)keyValue);
    }

    public static boolean hasDenizenKey(PersistentDataHolder holder, String keyName) {
        return holder.getPersistentDataContainer().has(new NamespacedKey((Plugin)Denizen.getInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
    }

    public static ObjectTag getDenizenKey(PersistentDataHolder holder, String keyName) {
        try {
            return (ObjectTag)holder.getPersistentDataContainer().get(new NamespacedKey((Plugin)Denizen.getInstance(), keyName), (PersistentDataType)PERSISTER_TYPE);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            if (holder instanceof Entity) {
                Debug.echoError("Failed to read ObjectTag from entity key '" + keyName + "' for entity " + ((Entity)holder).getUniqueId() + "...");
            } else {
                Debug.echoError("Failed to read ObjectTag from object key '" + keyName + "' for holder '" + holder.toString() + "'...");
            }
            Debug.echoError(ex);
            return null;
        }
    }

    public static class DenizenObjectType
    implements PersistentDataType<String, ObjectTag> {
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<ObjectTag> getComplexType() {
            return ObjectTag.class;
        }

        public String toPrimitive(ObjectTag complex, PersistentDataAdapterContext context) {
            return complex.toString();
        }

        public ObjectTag fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return ObjectFetcher.pickObjectFor(primitive, CoreUtilities.noDebugContext);
        }
    }
}

