/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.flags;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerFlagHandler
implements Listener {
    public static long cacheTimeoutSeconds = 300L;
    public static boolean asyncPreload = false;
    public static File dataFolder;
    public static HashMap<UUID, CachedPlayerFlag> playerFlagTrackerCache;
    public static HashMap<UUID, SoftReference<CachedPlayerFlag>> secondaryPlayerFlagTrackerCache;
    private static ArrayList<UUID> toClearCache;

    public static void cleanCache() {
        if (cacheTimeoutSeconds == -1L) {
            return;
        }
        toClearCache.clear();
        for (Map.Entry<UUID, SoftReference<CachedPlayerFlag>> entry : secondaryPlayerFlagTrackerCache.entrySet()) {
            if (entry.getValue().get() != null) continue;
            toClearCache.add(entry.getKey());
        }
        for (UUID id : toClearCache) {
            secondaryPlayerFlagTrackerCache.remove(id);
        }
        long timeNow = System.currentTimeMillis();
        for (Map.Entry<UUID, CachedPlayerFlag> entry : playerFlagTrackerCache.entrySet()) {
            if (cacheTimeoutSeconds > 0L && entry.getValue().lastAccessed + cacheTimeoutSeconds * 1000L < timeNow) continue;
            if (Bukkit.getPlayer((UUID)entry.getKey()) != null) {
                entry.getValue().lastAccessed = timeNow;
                continue;
            }
            PlayerFlagHandler.saveThenExpire(entry.getKey(), entry.getValue());
        }
    }

    public static void saveThenExpire(final UUID id, final CachedPlayerFlag cache) {
        final BukkitRunnable expireTask = new BukkitRunnable(){

            public void run() {
                if (cache.shouldExpire()) {
                    playerFlagTrackerCache.remove(id);
                    secondaryPlayerFlagTrackerCache.put(id, new SoftReference<CachedPlayerFlag>(cache));
                }
            }
        };
        if (cache.savingNow || cache.loadingNow) {
            new BukkitRunnable(){

                public void run() {
                    CachedPlayerFlag newCache = playerFlagTrackerCache.get(id);
                    if (newCache != null) {
                        PlayerFlagHandler.saveThenExpire(id, newCache);
                    }
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 10L);
            return;
        }
        if (!cache.tracker.modified) {
            expireTask.runTaskLater((Plugin)Denizen.getInstance(), 1L);
            return;
        }
        cache.tracker.modified = false;
        final String text = cache.tracker.toString();
        cache.savingNow = true;
        new BukkitRunnable(){

            public void run() {
                try {
                    PlayerFlagHandler.saveFlags(id, text);
                }
                catch (Throwable ex) {
                    Debug.echoError(ex);
                }
                cache.savingNow = false;
                expireTask.runTaskLater((Plugin)Denizen.getInstance(), 1L);
            }
        }.runTaskAsynchronously((Plugin)Denizen.getInstance());
    }

    public static void loadFlags(UUID id, CachedPlayerFlag cache) {
        cache.tracker = SavableMapFlagTracker.loadFlagFile(new File(dataFolder, id.toString()).getPath());
        cache.loadingNow = false;
    }

    public static AbstractFlagTracker getTrackerFor(UUID id) {
        CachedPlayerFlag cache = playerFlagTrackerCache.get(id);
        if (cache == null) {
            SoftReference<CachedPlayerFlag> softRef = secondaryPlayerFlagTrackerCache.get(id);
            if (softRef != null && (cache = softRef.get()) != null) {
                cache.lastAccessed = System.currentTimeMillis();
                playerFlagTrackerCache.put(id, cache);
                secondaryPlayerFlagTrackerCache.remove(id);
                return cache.tracker;
            }
            cache = new CachedPlayerFlag();
            cache.lastAccessed = System.currentTimeMillis();
            cache.loadingNow = true;
            playerFlagTrackerCache.put(id, cache);
            PlayerFlagHandler.loadFlags(id, cache);
        } else {
            while (cache.loadingNow) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Debug.echoError(ex);
                }
            }
        }
        return cache.tracker;
    }

    public static Future loadAsync(final UUID id) {
        try {
            CachedPlayerFlag cache = playerFlagTrackerCache.get(id);
            if (cache != null) {
                return null;
            }
            SoftReference<CachedPlayerFlag> softRef = secondaryPlayerFlagTrackerCache.get(id);
            if (softRef != null && (cache = softRef.get()) != null) {
                cache.lastAccessed = System.currentTimeMillis();
                playerFlagTrackerCache.put(id, cache);
                secondaryPlayerFlagTrackerCache.remove(id);
                return null;
            }
            final CachedPlayerFlag newCache = new CachedPlayerFlag();
            newCache.lastAccessed = System.currentTimeMillis();
            newCache.loadingNow = true;
            playerFlagTrackerCache.put(id, newCache);
            final CompletableFuture future = new CompletableFuture();
            new BukkitRunnable(){

                public void run() {
                    PlayerFlagHandler.loadFlags(id, newCache);
                    future.complete(null);
                }
            }.runTaskAsynchronously((Plugin)Denizen.getInstance());
            return future;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static void saveAllNow(boolean canSleep) {
        for (Map.Entry<UUID, CachedPlayerFlag> entry : playerFlagTrackerCache.entrySet()) {
            if (!entry.getValue().tracker.modified || !canSleep && entry.getValue().savingNow || entry.getValue().loadingNow) continue;
            while (entry.getValue().savingNow || entry.getValue().loadingNow) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Debug.echoError(ex);
                }
            }
            entry.getValue().tracker.modified = false;
            PlayerFlagHandler.saveFlags(entry.getKey(), entry.getValue().tracker.toString());
        }
    }

    public static void saveFlags(UUID id, String flagData) {
        SavableMapFlagTracker.saveToFile(new File(dataFolder, id.toString()).getPath(), flagData);
    }

    @EventHandler
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        if (!asyncPreload) {
            return;
        }
        UUID id = event.getUniqueId();
        if (!Bukkit.isPrimaryThread()) {
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Denizen.getInstance(), () -> PlayerFlagHandler.loadAsync(id));
            try {
                Future newFuture = (Future)future.get(15L, TimeUnit.SECONDS);
                if (newFuture != null) {
                    newFuture.get(15L, TimeUnit.SECONDS);
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    static {
        playerFlagTrackerCache = new HashMap();
        secondaryPlayerFlagTrackerCache = new HashMap();
        toClearCache = new ArrayList();
    }

    public static class CachedPlayerFlag {
        public long lastAccessed;
        public SavableMapFlagTracker tracker;
        public boolean savingNow = false;
        public boolean loadingNow = false;

        public boolean shouldExpire() {
            if (cacheTimeoutSeconds == -1L) {
                return false;
            }
            if (cacheTimeoutSeconds == 0L) {
                return true;
            }
            return this.lastAccessed + cacheTimeoutSeconds * 1000L < System.currentTimeMillis();
        }
    }
}

