/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class VehicleMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleMoveScriptEvent instance;
    public dEntity vehicle;
    public dLocation from;
    public dLocation to;
    public VehicleMoveEvent event;

    public VehicleMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "moves");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.tryEntity(this.vehicle, CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.vehicle.getLocation());
    }

    @Override
    public String getName() {
        return "VehicleMoves";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        VehicleMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("from")) {
            return this.from;
        }
        if (name.equals("to")) {
            return this.to;
        }
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        this.to = new dLocation(event.getTo());
        this.from = new dLocation(event.getFrom());
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.event = event;
        this.fire();
    }
}

