/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapView;

public abstract class MapObject {
    protected String xTag;
    protected String yTag;
    protected String visibilityTag;
    protected Map<UUID, Integer> currentX = new HashMap<UUID, Integer>();
    protected Map<UUID, Integer> currentY = new HashMap<UUID, Integer>();
    protected Map<UUID, Boolean> currentVisibility = new HashMap<UUID, Boolean>();
    protected boolean debug;
    public MapView lastMap;
    public boolean worldCoordinates = false;

    public MapObject(String xTag, String yTag, String visibilityTag, boolean debug) {
        this.xTag = xTag;
        this.yTag = yTag;
        this.visibilityTag = visibilityTag;
        this.debug = debug;
    }

    public void update(PlayerTag player, UUID uuid) {
        this.currentX.put(uuid, this.getX(player, uuid));
        this.currentY.put(uuid, this.getY(player, uuid));
        this.currentVisibility.put(uuid, this.tag(this.visibilityTag, player).equalsIgnoreCase("true"));
    }

    public int getX(PlayerTag player, UUID uuid) {
        int x = (int)Double.parseDouble(this.tag(this.xTag, player));
        this.currentX.put(uuid, x);
        if (this.worldCoordinates && this.lastMap != null) {
            float f = (float)(x - this.lastMap.getCenterX()) / (float)(1 << this.lastMap.getScale().getValue());
            int bx = (int)((double)(f * 2.0f) + 0.5);
            return bx < -127 ? -127 : (bx > 127 ? 127 : bx);
        }
        return x;
    }

    public int getY(PlayerTag player, UUID uuid) {
        int y = (int)Double.parseDouble(this.tag(this.yTag, player));
        this.currentY.put(uuid, y);
        if (this.worldCoordinates && this.lastMap != null) {
            float f1 = (float)(y - this.lastMap.getCenterZ()) / (float)(1 << this.lastMap.getScale().getValue());
            int by = (int)((double)(f1 * 2.0f) + 0.5);
            return by < -127 ? -127 : (by > 127 ? 127 : by);
        }
        return y;
    }

    public boolean isVisibleTo(PlayerTag player, UUID uuid) {
        if (!this.currentVisibility.containsKey(uuid)) {
            this.currentVisibility.put(uuid, this.tag(this.visibilityTag, player).equalsIgnoreCase("true"));
        }
        return this.currentVisibility.get(uuid);
    }

    public TagContext getTagContext(PlayerTag player) {
        return new BukkitTagContext(player, player.getSelectedNPC(), null, this.debug, null);
    }

    protected String tag(String arg, PlayerTag player) {
        return TagManager.tag(arg, this.getTagContext(player));
    }

    public Map<String, Object> getSaveData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", this.xTag);
        data.put("y", this.yTag);
        data.put("visibility", this.visibilityTag);
        data.put("debug", this.debug ? "true" : "false");
        data.put("world_coordinates", this.worldCoordinates ? "true" : "false");
        return data;
    }

    public abstract void render(MapView var1, MapCanvas var2, PlayerTag var3, UUID var4);
}

