/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class TNTPrimesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static TNTPrimesScriptEvent instance;
    public TNTPrimeEvent event;
    public LocationTag location;

    public TNTPrimesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("tnt primes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "TNTPrimes";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getPrimerEntity());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity") && this.event.getPrimerEntity() != null) {
            return new EntityTag(this.event.getPrimerEntity());
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("reason")) {
            return new ElementTag(this.event.getReason().name());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void tntPrimeEvent(TNTPrimeEvent event) {
        this.event = event;
        this.location = new LocationTag(event.getBlock().getLocation());
        this.fire((Event)event);
    }
}

