/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TriggerTrait
extends Trait
implements Listener {
    @Persist(value="enabled", collectionType=HashMap.class)
    private Map<String, Boolean> enabled = new HashMap<String, Boolean>();
    @Persist(value="properly_set", collectionType=HashMap.class)
    public Map<String, Boolean> properly_set = new HashMap<String, Boolean>();
    @Persist(value="duration", collectionType=HashMap.class)
    private Map<String, Double> duration = new HashMap<String, Double>();
    @Persist(value="radius", collectionType=HashMap.class)
    private Map<String, Integer> radius = new HashMap<String, Integer>();

    public void report() {
        Debug.log("enabled: " + this.enabled.entrySet().toString());
        Debug.log("duration: " + this.duration.entrySet().toString());
        Debug.log("radius: " + this.radius.entrySet().toString());
    }

    public TriggerTrait() {
        super("triggers");
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            if (this.properly_set.containsKey(entry.getKey())) continue;
            this.properly_set.put(entry.getKey(), entry.getValue());
        }
        for (String triggerName : Denizen.getInstance().getTriggerRegistry().list().keySet()) {
            if (this.enabled.containsKey(triggerName)) continue;
            this.enabled.put(triggerName, Settings.triggerEnabled(triggerName));
            this.properly_set.put(triggerName, false);
        }
    }

    public void onSpawn() {
        for (String triggerName : Denizen.getInstance().getTriggerRegistry().list().keySet()) {
            if (this.enabled.containsKey(triggerName)) continue;
            this.enabled.put(triggerName, Settings.triggerEnabled(triggerName));
        }
    }

    public void load(DataKey key) {
        if (!key.keyExists("properly_set") && key.keyExists("enabled")) {
            for (String triggerName : Denizen.getInstance().getTriggerRegistry().list().keySet()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.properly_set.put(triggerName, key.getBoolean("enabled." + triggerName)));
            }
        }
    }

    public String toggleTrigger(String triggerName, boolean toggle) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            this.enabled.put(triggerName.toUpperCase(), toggle);
            this.properly_set.put(triggerName.toUpperCase(), true);
            return triggerName + " trigger is now " + (toggle ? "enabled." : "disabled.");
        }
        return triggerName + " trigger not found!";
    }

    public String toggleTrigger(String triggerName) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            if (this.enabled.get(triggerName.toUpperCase()).booleanValue()) {
                this.enabled.put(triggerName.toUpperCase(), false);
                return triggerName + " trigger is now disabled.";
            }
            this.enabled.put(triggerName.toUpperCase(), true);
            this.properly_set.put(triggerName.toUpperCase(), true);
            return triggerName + " trigger is now enabled.";
        }
        return triggerName + " trigger not found!";
    }

    public boolean hasTrigger(String triggerName) {
        return this.enabled.containsKey(triggerName.toUpperCase()) && this.enabled.get(triggerName.toUpperCase()) != false;
    }

    public boolean isEnabled(String triggerName) {
        if (!new NPCTag(this.npc).getAssignmentTrait().hasAssignment()) {
            return false;
        }
        return this.enabled.getOrDefault(triggerName.toUpperCase(), false);
    }

    public void setLocalCooldown(String triggerName, double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.duration.put(triggerName.toUpperCase(), value);
    }

    public double getCooldownDuration(String triggerName) {
        if (this.duration.containsKey(triggerName.toUpperCase())) {
            return this.duration.get(triggerName.toUpperCase());
        }
        return Settings.triggerDefaultCooldown(triggerName);
    }

    public void setLocalRadius(String triggerName, int value) {
        this.radius.put(triggerName.toUpperCase(), value);
    }

    public double getRadius(String triggerName) {
        if (this.radius.containsKey(triggerName.toUpperCase())) {
            return this.radius.get(triggerName.toUpperCase()).intValue();
        }
        return Settings.triggerDefaultRange(triggerName);
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Triggers");
        paginator.addLine("<e>Key: <a>Name  <b>Status  <c>Cooldown  <d>Cooldown Type  <e>(Radius)");
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            String line = "<a> " + entry.getKey() + "<b> " + (entry.getValue() != false ? "Enabled" : "Disabled") + "<c> " + this.getCooldownDuration(entry.getKey()) + "<e> " + (this.getRadius(entry.getKey()) == -1.0 ? "" : Double.valueOf(this.getRadius(entry.getKey())));
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public boolean triggerCooldownOnly(AbstractTrigger triggerClass, PlayerTag player) {
        if (!Denizen.getInstance().getTriggerRegistry().checkCooldown(this.npc, player, triggerClass)) {
            return false;
        }
        if (EngageCommand.getEngaged(this.npc)) {
            return false;
        }
        Denizen.getInstance().getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()));
        return true;
    }

    public TriggerContext trigger(AbstractTrigger triggerClass, PlayerTag player) {
        return this.trigger(triggerClass, player, null);
    }

    public TriggerContext trigger(AbstractTrigger triggerClass, PlayerTag player, Map<String, ObjectTag> context) {
        String trigger_type = triggerClass.getName();
        if (!Denizen.getInstance().getTriggerRegistry().checkCooldown(this.npc, player, triggerClass)) {
            return new TriggerContext(false);
        }
        if (context == null) {
            context = new HashMap<String, ObjectTag>();
        }
        if (EngageCommand.getEngaged(this.npc)) {
            context.put("trigger_type", new ElementTag(trigger_type));
            if (!new NPCTag(this.npc).action("unavailable", player, context).equalsIgnoreCase("available")) {
                return new TriggerContext(false);
            }
        }
        Denizen.getInstance().getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(trigger_type));
        String determination = new NPCTag(this.npc).action(trigger_type, player, context);
        return new TriggerContext(determination, true);
    }

    public class TriggerContext {
        String determination;
        boolean triggered;

        public TriggerContext(boolean triggered) {
            this.triggered = triggered;
        }

        public TriggerContext(String determination, boolean triggered) {
            this.determination = determination;
            this.triggered = triggered;
        }

        public boolean hasDetermination() {
            return this.determination != null && !this.determination.equalsIgnoreCase("none");
        }

        public String getDetermination() {
            return this.determination;
        }

        public boolean wasTriggered() {
            return this.triggered;
        }
    }
}

