/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import org.bukkit.Axis;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Rotatable;

public class FullBlockData {
    public BlockData data;
    public CompoundTag tileEntityData;

    public FullBlockData(Block block) {
        this(block.getBlockData());
        this.tileEntityData = NMSHandler.getBlockHelper().getNbtData(block);
    }

    public FullBlockData(BlockData data) {
        this.data = data;
    }

    public static BlockFace rotateFaceOne(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case NORTH_EAST: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case NORTH_NORTH_WEST: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case SOUTH_SOUTH_EAST: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case EAST_NORTH_EAST: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case WEST_NORTH_WEST: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case WEST_SOUTH_WEST: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case EAST_SOUTH_EAST: {
                return BlockFace.NORTH_NORTH_EAST;
            }
        }
        return face;
    }

    public static Rail.Shape rotateRailShapeOne(Rail.Shape shape) {
        switch (shape) {
            case NORTH_SOUTH: {
                return Rail.Shape.EAST_WEST;
            }
            case EAST_WEST: {
                return Rail.Shape.NORTH_SOUTH;
            }
            case ASCENDING_EAST: {
                return Rail.Shape.ASCENDING_NORTH;
            }
            case ASCENDING_WEST: {
                return Rail.Shape.ASCENDING_SOUTH;
            }
            case ASCENDING_NORTH: {
                return Rail.Shape.ASCENDING_WEST;
            }
            case ASCENDING_SOUTH: {
                return Rail.Shape.ASCENDING_EAST;
            }
            case SOUTH_EAST: {
                return Rail.Shape.NORTH_EAST;
            }
            case SOUTH_WEST: {
                return Rail.Shape.SOUTH_EAST;
            }
            case NORTH_WEST: {
                return Rail.Shape.SOUTH_WEST;
            }
            case NORTH_EAST: {
                return Rail.Shape.NORTH_WEST;
            }
        }
        return shape;
    }

    public FullBlockData rotateOne() {
        if (this.data instanceof Orientable) {
            BlockData newData = this.data.clone();
            switch (((Orientable)this.data).getAxis()) {
                case X: {
                    ((Orientable)newData).setAxis(Axis.Z);
                    break;
                }
                case Z: {
                    ((Orientable)newData).setAxis(Axis.X);
                }
            }
            return new FullBlockData(newData);
        }
        if (this.data instanceof Rotatable) {
            BlockData newData = this.data.clone();
            ((Rotatable)newData).setRotation(FullBlockData.rotateFaceOne(((Rotatable)this.data).getRotation()));
            return new FullBlockData(newData);
        }
        if (this.data instanceof Directional) {
            BlockData newData = this.data.clone();
            ((Directional)newData).setFacing(FullBlockData.rotateFaceOne(((Directional)this.data).getFacing()));
            return new FullBlockData(newData);
        }
        if (this.data instanceof Rail) {
            BlockData newData = this.data.clone();
            ((Rail)newData).setShape(FullBlockData.rotateRailShapeOne(((Rail)this.data).getShape()));
            return new FullBlockData(newData);
        }
        return this;
    }

    public void set(Block block, boolean physics) {
        block.setBlockData(this.data, physics);
        if (this.tileEntityData != null) {
            NMSHandler.getBlockHelper().setNbtData(block, this.tileEntityData);
        }
    }
}

