/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SQLCommand
extends AbstractCommand
implements Holdable {
    public static Map<String, Connection> connections = new HashMap<String, Connection>();

    public SQLCommand() {
        this.setName("sql");
        this.setSyntax("sql [id:<ID>] [disconnect/connect:<server> (username:<username>) (password:<password>) (ssl:true/{false})/query:<query>/update:<update>]");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
    }

    @Override
    public void onDisable() {
        for (Map.Entry<String, Connection> entry : connections.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (SQLException e) {
                Debug.echoError(e);
            }
        }
        connections.clear();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("sqlid") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("sqlid", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("connect")) {
                scriptEntry.addObject("action", new ElementTag("CONNECT"));
                scriptEntry.addObject("server", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("disconnect")) {
                scriptEntry.addObject("action", new ElementTag("DISCONNECT"));
                continue;
            }
            if (!scriptEntry.hasObject("query") && arg.matchesPrefix("query")) {
                scriptEntry.addObject("action", new ElementTag("QUERY"));
                scriptEntry.addObject("query", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("query") && arg.matchesPrefix("update")) {
                scriptEntry.addObject("action", new ElementTag("UPDATE"));
                scriptEntry.addObject("query", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("username") && arg.matchesPrefix("username")) {
                scriptEntry.addObject("username", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("password") && arg.matchesPrefix("password")) {
                scriptEntry.addObject("password", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("ssl") && arg.matchesPrefix("ssl") && arg.asElement().isBoolean()) {
                scriptEntry.addObject("ssl", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sqlid")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        if (!scriptEntry.hasObject("ssl")) {
            scriptEntry.defaultObject("ssl", new ElementTag("false"));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block25: {
            ElementTag action = scriptEntry.getElement("action");
            ElementTag server = scriptEntry.getElement("server");
            ElementTag username = scriptEntry.getElement("username");
            ElementTag password = scriptEntry.getElement("password");
            ElementTag ssl = scriptEntry.getElement("ssl");
            ElementTag sqlID = scriptEntry.getElement("sqlid");
            ElementTag query = scriptEntry.getElement("query");
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), sqlID.debug() + action.debug() + (server != null ? server.debug() : "") + (username != null ? username.debug() : "") + (password != null ? ArgumentHelper.debugObj("password", "NotLogged") : "") + (query != null ? query.debug() : ""));
            }
            if (!(action.asString().equalsIgnoreCase("connect") || action.asString().equalsIgnoreCase("query") && scriptEntry.shouldWaitFor())) {
                scriptEntry.setFinished(true);
            }
            try {
                if (action.asString().equalsIgnoreCase("connect")) {
                    if (server == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a server!");
                        return;
                    }
                    if (username == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a username!");
                        return;
                    }
                    if (password == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a password!");
                        return;
                    }
                    if (connections.containsKey(sqlID.asString().toUpperCase())) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Already connected to a server with ID '" + sqlID.asString() + "'!");
                        return;
                    }
                    DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(() -> {
                        Connection con = null;
                        if (Debug.verbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connecting to " + server.asString());
                        }
                        try {
                            con = this.getConnection(username.asString(), password.asString(), server.asString(), ssl.asString());
                        }
                        catch (Exception e) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "SQL Exception: " + e.getMessage());
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), e);
                                }
                            }, 0.0f));
                        }
                        if (Debug.verbose) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Connection did not error");
                        }
                        Connection conn = con;
                        if (con != null) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                connections.put(sqlID.asString().toUpperCase(), conn);
                                Debug.echoDebug((Debuggable)scriptEntry, "Successfully connected to " + server);
                                scriptEntry.setFinished(true);
                            }, 0.0f));
                        } else {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Connecting errored!");
                                }
                            }, 0.0f));
                        }
                    }, 0.0f)));
                } else if (action.asString().equalsIgnoreCase("disconnect")) {
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to server with ID '" + sqlID.asString() + "'!");
                        return;
                    }
                    con.close();
                    connections.remove(sqlID.asString().toUpperCase());
                    Debug.echoDebug((Debuggable)scriptEntry, "Disconnected from '" + sqlID.asString() + "'.");
                } else if (action.asString().equalsIgnoreCase("query")) {
                    if (query == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a query!");
                        return;
                    }
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to server with ID '" + sqlID.asString() + "'!");
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Running query " + query.asString());
                    Runnable doQuery = () -> {
                        try {
                            Statement statement = con.createStatement();
                            ResultSet set = statement.executeQuery(query.asString());
                            ResultSetMetaData rsmd = set.getMetaData();
                            int columns = rsmd.getColumnCount();
                            int count = 0;
                            ListTag rows = new ListTag();
                            while (set.next()) {
                                ++count;
                                StringBuilder current = new StringBuilder();
                                for (int i = 0; i < columns; ++i) {
                                    current.append(EscapeTagBase.escape(set.getString(i + 1))).append("/");
                                }
                                rows.add(current.toString());
                            }
                            scriptEntry.addObject("result", rows);
                            int finalCount = count;
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoDebug((Debuggable)scriptEntry, "Got a query result of " + columns + " columns and " + finalCount + " rows");
                                scriptEntry.setFinished(true);
                            }, 0.0f));
                        }
                        catch (Exception ex) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "SQL Exception: " + ex.getMessage());
                                scriptEntry.setFinished(true);
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                                }
                            }, 0.0f));
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(doQuery, 0.0f)));
                    } else {
                        doQuery.run();
                    }
                } else if (action.asString().equalsIgnoreCase("update")) {
                    if (query == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Must specify an update query!");
                        return;
                    }
                    Connection con = connections.get(sqlID.asString().toUpperCase());
                    if (con == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Not connected to server with ID '" + sqlID.asString() + "'!");
                        return;
                    }
                    Debug.echoDebug((Debuggable)scriptEntry, "Running update " + query.asString());
                    Runnable doUpdate = () -> {
                        try {
                            Statement statement = con.createStatement();
                            int affected = statement.executeUpdate(query.asString(), 1);
                            scriptEntry.addObject("affected_rows", new ElementTag(affected));
                            ResultSet set = statement.getGeneratedKeys();
                            ResultSetMetaData rsmd = set.getMetaData();
                            int columns = rsmd.getColumnCount();
                            ListTag rows = new ListTag();
                            while (set.next()) {
                                StringBuilder current = new StringBuilder();
                                for (int i = 0; i < columns; ++i) {
                                    current.append(EscapeTagBase.escape(set.getString(i + 1))).append("/");
                                }
                                rows.add(current.toString());
                            }
                            scriptEntry.addObject("result", rows);
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoDebug((Debuggable)scriptEntry, "Got a query result of " + columns + " columns");
                                Debug.echoDebug((Debuggable)scriptEntry, "Updated " + affected + " rows");
                                scriptEntry.setFinished(true);
                            }, 0.0f));
                        }
                        catch (Exception ex) {
                            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                                Debug.echoError(scriptEntry.getResidingQueue(), "SQL Exception: " + ex.getMessage());
                                if (Debug.verbose) {
                                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                                }
                            }, 0.0f));
                        }
                    };
                    if (scriptEntry.shouldWaitFor()) {
                        DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(doUpdate, 0.0f)));
                    } else {
                        doUpdate.run();
                    }
                } else {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Unknown action '" + action.asString() + "'");
                }
            }
            catch (SQLException ex) {
                Debug.echoError(scriptEntry.getResidingQueue(), "SQL Exception: " + ex.getMessage());
                if (!Debug.verbose) break block25;
                Debug.echoError(scriptEntry.getResidingQueue(), ex);
            }
        }
    }

    public Connection getConnection(String userName, String password, String server, String ssl) throws SQLException {
        Properties connectionProps = new Properties();
        connectionProps.put("user", userName);
        connectionProps.put("password", password);
        connectionProps.put("useSSL", ssl);
        connectionProps.put("LoginTimeout", "7");
        if (!server.contains("://")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            server = "mysql://" + server;
        }
        return DriverManager.getConnection("jdbc:" + server, connectionProps);
    }
}

