/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.function.Consumer;

public class TriggerCommand
extends AbstractCommand {
    public TriggerCommand() {
        this.setName("trigger");
        this.setSyntax("trigger [name:<trigger>] (state:{toggle}/true/false) (cooldown:<duration>) (radius:<#>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        addOne.accept("name:click");
        addOne.accept("name:chat");
        addOne.accept("name:damage");
        addOne.accept("name:proximity");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("cooldown") && arg.matchesPrefix("cooldown", "c") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("cooldown", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrefix("radius", "r") && arg.matchesInteger()) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("toggle") && arg.matchesEnum(Toggle.values())) {
                scriptEntry.addObject("toggle", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("npc") && arg.matchesArgumentType(NPCTag.class)) {
                scriptEntry.addObject("npc", arg.asType(NPCTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("trigger")) {
                scriptEntry.addObject("trigger", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("trigger")) {
            throw new InvalidArgumentsException("Missing name argument!");
        }
        if (!scriptEntry.hasObject("toggle")) {
            scriptEntry.addObject("toggle", new ElementTag("TOGGLE"));
        }
        if (!Utilities.entryHasNPC(scriptEntry) && !scriptEntry.hasObject("npc")) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        NPCTag npc;
        ElementTag toggle = scriptEntry.getElement("toggle");
        ElementTag trigger = scriptEntry.getElement("trigger");
        ElementTag radius = scriptEntry.getElement("radius");
        DurationTag cooldown = (DurationTag)scriptEntry.getObjectTag("cooldown");
        NPCTag nPCTag = npc = scriptEntry.hasObject("npc") ? (NPCTag)scriptEntry.getObject("npc") : Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), trigger.debug() + toggle.debug() + (radius != null ? radius.debug() : "") + (cooldown != null ? cooldown.debug() : "") + npc.debug());
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            npc.getCitizen().addTrait(TriggerTrait.class);
        }
        TriggerTrait trait = (TriggerTrait)npc.getCitizen().getOrAddTrait(TriggerTrait.class);
        switch (Toggle.valueOf(toggle.asString().toUpperCase())) {
            case TOGGLE: {
                trait.toggleTrigger(trigger.asString());
                break;
            }
            case TRUE: {
                trait.toggleTrigger(trigger.asString(), true);
                break;
            }
            case FALSE: {
                trait.toggleTrigger(trigger.asString(), false);
            }
        }
        if (radius != null) {
            trait.setLocalRadius(trigger.asString(), radius.asInt());
        }
        if (cooldown != null) {
            trait.setLocalCooldown(trigger.asString(), cooldown.getSeconds());
        }
    }

    private static enum Toggle {
        TOGGLE,
        TRUE,
        FALSE;

    }
}

