/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.function.Consumer;
import org.bukkit.Location;

public class ExplodeCommand
extends AbstractCommand {
    public ExplodeCommand() {
        this.setName("explode");
        this.setSyntax("explode (power:<#.#>) (<location>) (fire) (breakblocks) (source:<entity>)");
        this.setRequiredArguments(0, 5);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Notable note : NotableManager.notesByType.get(LocationTag.class)) {
            addOne.accept(NotableManager.getSavedId(note));
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesFloat() && arg.matchesPrefix("power", "p")) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesArgumentType(EntityTag.class) && arg.matchesPrefix("source")) {
                scriptEntry.addObject("source", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("breakblocks") && arg.matches("breakblocks")) {
                scriptEntry.addObject("breakblocks", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("fire") && arg.matches("fire")) {
                scriptEntry.addObject("fire", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("power", new ElementTag(1.0));
        scriptEntry.defaultObject("fire", new ElementTag(false));
        scriptEntry.defaultObject("breakblocks", new ElementTag(false));
        scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, false));
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag power = scriptEntry.getElement("power");
        ElementTag breakblocks = scriptEntry.getElement("breakblocks");
        ElementTag fire = scriptEntry.getElement("fire");
        EntityTag source = (EntityTag)scriptEntry.getObjectTag("source");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), location.debug() + (source == null ? "" : source.debug()) + power.debug() + breakblocks.debug() + fire.debug());
        }
        location.getWorld().createExplosion((Location)location, power.asFloat(), fire.asBoolean(), breakblocks.asBoolean(), source == null ? null : source.getBukkitEntity());
    }
}

