/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;

public class EntityTargetsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityTargetsScriptEvent instance;
    public dEntity entity;
    public Element reason;
    public dEntity target;
    public dList cuboids;
    private dLocation location;
    public EntityTargetEvent event;

    public EntityTargetsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("targets");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        if (!this.tryEntity(this.entity, CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        String victim = CoreUtilities.getXthArg(2, lower);
        if (!(victim.equals("in") || victim.equals("because") || victim.equals("") || this.tryEntity(this.target, victim))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        Integer pos = lower.indexOf(" because ") + 9;
        if (pos > 9) {
            Integer end = lower.indexOf(" ", (int)pos) < 0 ? lower.length() : lower.indexOf(" ", (int)pos);
            if (!lower.substring(pos, end).equals(CoreUtilities.toLowerCase(this.reason.toString()))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "EntityTargets";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityTargetEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dEntity.matches(determination)) {
            this.target = dEntity.valueOf(determination);
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("cuboids")) {
            return this.cuboids;
        }
        if (name.equals("target") && this.target != null) {
            return this.target.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTargets(EntityTargetEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.reason = new Element(event.getReason().toString());
        this.target = event.getTarget() != null ? new dEntity(event.getTarget()) : null;
        this.location = new dLocation(event.getEntity().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

