/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;

public class PlayerSwapsItemsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerSwapsItemsScriptEvent instance;
    public dPlayer player;
    public dItem mainhand;
    public dItem offhand;
    public PlayerSwapHandItemsEvent event;

    public PlayerSwapsItemsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player swaps items");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return true;
    }

    @Override
    public String getName() {
        return "PlayerSwapsItems";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerSwapHandItemsEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("main:")) {
            this.event.setMainHandItem(dItem.valueOf(determination.substring("main:".length())).getItemStack());
            return true;
        }
        if (lower.startsWith("offhand:")) {
            this.event.setOffHandItem(dItem.valueOf(determination.substring("offhand:".length())).getItemStack());
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("main")) {
            return this.mainhand;
        }
        if (name.equals("offhand")) {
            return this.offhand;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerSwapsItems(PlayerSwapHandItemsEvent event) {
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.mainhand = new dItem(event.getMainHandItem());
        this.offhand = new dItem(event.getOffHandItem());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

