/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.plugin.Plugin;

public class BlockSpreadsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockSpreadsScriptEvent instance;
    public dLocation location;
    public dLocation source;
    public dMaterial material;
    public BlockSpreadEvent event;

    public BlockSpreadsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("spreads") && !lower.startsWith("liquid");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat = CoreUtilities.getXthArg(0, lower);
        return this.tryMaterial(this.material, mat);
    }

    @Override
    public String getName() {
        return "BlockSpreads";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockSpreadEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("material")) {
            return this.material;
        }
        if (name.equals("source_location")) {
            return this.source;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockSpreads(BlockSpreadEvent event) {
        this.source = new dLocation(event.getBlock().getLocation());
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getSource().getType(), event.getSource().getData());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

