/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;

public class ItemMap
implements Property {
    public static Material MAP_MATERIAL = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) ? Material.FILLED_MAP : Material.MAP;
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getType() == MAP_MATERIAL;
    }

    public static ItemMap getFrom(dObject _item) {
        if (!ItemMap.describes(_item)) {
            return null;
        }
        return new ItemMap((dItem)_item);
    }

    private ItemMap(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("map")) {
            return new Element(this.getMapId()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public int getMapId() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            MapMeta map = (MapMeta)this.item.getItemStack().getItemMeta();
            return map.getMapId();
        }
        return this.item.getItemStack().getDurability();
    }

    public void setMapId(int id) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            MapMeta map = (MapMeta)this.item.getItemStack().getItemMeta();
            map.setMapId(id);
            this.item.getItemStack().setItemMeta((ItemMeta)map);
        }
        this.item.getItemStack().setDurability((short)id);
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getMapId());
    }

    @Override
    public String getPropertyId() {
        return "map";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("map") && mechanism.requireInteger()) {
            this.setMapId(mechanism.getValue().asInt());
        }
    }
}

