/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.json.JSONObject;

public class dScript
implements dObject,
Adjustable {
    private ScriptContainer container;
    private String prefix = "Container";
    private boolean valid = false;
    private String name = null;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dScript valueOf(String string) {
        return dScript.valueOf(string, null);
    }

    @Fetchable(value="s")
    public static dScript valueOf(String string, TagContext context) {
        dScript script;
        if (string.startsWith("s@")) {
            string = string.substring(2);
        }
        if ((script = new dScript(string)).isValid()) {
            return script;
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("s@")) {
            return true;
        }
        dScript script = new dScript(string);
        return script.isValid();
    }

    public dScript(String scriptName) {
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public dScript(ScriptContainer container) {
        this.container = container;
        this.name = container.getName().toUpperCase();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    @Override
    public String getObjectType() {
        return "Container";
    }

    @Override
    public String identify() {
        return "s@" + this.name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return String.format("<G>%s='<A>%s<Y>(%s)<G>'  ", this.prefix, this.name, this.getType());
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    public static void registerTags() {
        dScript.registerTag("container_type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dScript)object).container.getContainerType()).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dScript)object).name).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("relative_filename", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                try {
                    String fn = ((dScript)object).container.getFileName().replace(DenizenCore.getImplementation().getScriptFolder().getParentFile().getCanonicalPath(), "").replace("\\", "/");
                    while (fn.startsWith("/")) {
                        fn = fn.substring(1);
                    }
                    return new Element(fn).getAttribute(attribute.fulfill(1));
                }
                catch (Exception e) {
                    dB.echoError(e);
                    return null;
                }
            }
        });
        dScript.registerTag("filename", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dScript)object).container.getFileName().replace("\\", "/")).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("original_name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dScript)object).container.getOriginalName()).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("constant", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag s@script.constant[...] must have a value.");
                    return null;
                }
                YamlConfiguration section = ((dScript)object).getContainer().getConfigurationSection("default constants");
                if (section == null) {
                    return null;
                }
                Object obj = section.get(attribute.getContext(1).toUpperCase());
                if (obj == null) {
                    return null;
                }
                if (obj instanceof List) {
                    dList list = new dList();
                    for (Object each : (List)obj) {
                        if (each == null) {
                            each = "null";
                        }
                        list.add(TagManager.tag(each.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
                    }
                    return list.getAttribute(attribute.fulfill(1));
                }
                return new Element(TagManager.tag(obj.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry()))).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("yaml_key", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag s@script.constant[...] must have a value.");
                    return null;
                }
                dScript scr = (dScript)object;
                ScriptContainer container = scr.getContainer();
                if (container == null) {
                    dB.echoError("Missing script container?!");
                    return new Element(scr.identify()).getAttribute(attribute);
                }
                YamlConfiguration section = container.getConfigurationSection("");
                if (section == null) {
                    dB.echoError("Missing YAML section?!");
                    return new Element(scr.identify()).getAttribute(attribute);
                }
                Object obj = section.get(attribute.getContext(1).toUpperCase());
                if (obj == null) {
                    return null;
                }
                if (obj instanceof List) {
                    dList list = new dList();
                    for (Object each : (List)obj) {
                        if (each == null) {
                            each = "null";
                        }
                        list.add(each.toString());
                    }
                    return list.getAttribute(attribute.fulfill(1));
                }
                return new Element(obj.toString()).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("list_keys", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                YamlConfiguration conf = ((dScript)object).getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
                if (conf == null) {
                    return null;
                }
                return new dList(conf.getKeys(false)).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("list_deep_keys", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                YamlConfiguration conf = ((dScript)object).getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "");
                if (conf == null) {
                    return null;
                }
                return new dList(conf.getKeys(true)).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("to_json", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                JSONObject jsobj = new JSONObject(((dScript)object).container.getConfigurationSection("").getMap());
                jsobj.remove("TYPE");
                return new Element(jsobj.toString()).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("debug", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("prefix", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dScript)object).prefix).getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Script").getAttribute(attribute.fulfill(1));
            }
        });
        dScript.registerTag("list_queues", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dScript script = (dScript)object;
                dList queues = new dList();
                for (ScriptQueue queue : ScriptQueue._getQueues()) {
                    if (queue.script == null || !queue.script.getName().equals(script.getName())) continue;
                    queues.add(queue.identify());
                }
                return queues.getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this, attrLow)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a script!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

