/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.material.MaterialAge;
import com.denizenscript.denizen.objects.properties.material.MaterialBlockType;
import com.denizenscript.denizen.objects.properties.material.MaterialCampfire;
import com.denizenscript.denizen.objects.properties.material.MaterialCount;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.objects.properties.material.MaterialDrags;
import com.denizenscript.denizen.objects.properties.material.MaterialFaces;
import com.denizenscript.denizen.objects.properties.material.MaterialHalf;
import com.denizenscript.denizen.objects.properties.material.MaterialLeafSize;
import com.denizenscript.denizen.objects.properties.material.MaterialLevel;
import com.denizenscript.denizen.objects.properties.material.MaterialLightable;
import com.denizenscript.denizen.objects.properties.material.MaterialPersistent;
import com.denizenscript.denizen.objects.properties.material.MaterialSnowable;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchFace;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchable;
import com.denizenscript.denizen.objects.properties.material.MaterialWaterlogged;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;

public class MaterialTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    public static TagContext noDebugContext = new BukkitTagContext(null, null, null, false, null);
    private Material material;
    private BlockData modernData;
    String prefix = "material";
    public static ObjectTagProcessor<MaterialTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="m")
    public static MaterialTag valueOf(String string, TagContext context) {
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(MaterialTag.class, string, context);
        }
        if ((string = string.toUpperCase()).startsWith("M@")) {
            string = string.substring("M@".length());
        }
        if (string.equals("RANDOM")) {
            return new MaterialTag(Material.values()[CoreUtilities.getRandom().nextInt(Material.values().length)]);
        }
        Material m = Material.getMaterial((String)string);
        if (m != null) {
            return new MaterialTag(m);
        }
        return null;
    }

    public static MaterialTag quickOfNamed(String string) {
        Material m = Material.getMaterial((String)string.toUpperCase());
        if (m != null) {
            return new MaterialTag(m);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return MaterialTag.valueOf(arg, noDebugContext) != null;
    }

    @Override
    public ObjectTag duplicate() {
        if (this.hasModernData()) {
            return new MaterialTag(this.getModernData().clone());
        }
        return new MaterialTag(this.getMaterial());
    }

    public boolean equals(Object object) {
        if (object instanceof MaterialTag) {
            return this.getMaterial() == ((MaterialTag)object).getMaterial();
        }
        MaterialTag parsed = MaterialTag.valueOf(object.toString(), CoreUtilities.noDebugContext);
        return this.equals(parsed);
    }

    public MaterialTag(Material material) {
        this.material = material;
        if (material.isBlock()) {
            this.modernData = material.createBlockData();
        }
    }

    public MaterialTag(BlockState state) {
        this.material = state.getType();
        this.modernData = state.getBlockData();
    }

    public MaterialTag(Block block) {
        this.modernData = block.getBlockData();
        this.material = this.modernData.getMaterial();
    }

    public MaterialTag(BlockData data) {
        this.modernData = data;
        this.material = data.getMaterial();
    }

    public boolean hasModernData() {
        return this.modernData != null;
    }

    public BlockData getModernData() {
        return this.modernData;
    }

    public void setModernData(BlockData data) {
        this.modernData = data;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String name() {
        return this.material.name();
    }

    public boolean isStructure() {
        return this.material == Material.CHORUS_PLANT || this.material == Material.RED_MUSHROOM_BLOCK || this.material == Material.BROWN_MUSHROOM_BLOCK;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Material";
    }

    @Override
    public String identify() {
        return "m@" + this.identifyNoIdentifier();
    }

    @Override
    public String identifySimple() {
        return "m@" + this.identifySimpleNoIdentifier();
    }

    public String identifyNoPropertiesNoIdentifier() {
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyNoIdentifier() {
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String identifySimpleNoIdentifier() {
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker(DenizenCore.getImplementation().getServerFlags(), "__materials." + this.material.name().replace(".", "&dot"));
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(tagProcessor);
        MaterialTag.registerTag("is_ageable", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialAge.describes(object));
        }, "is_plant");
        MaterialTag.registerTag("is_campfire", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialCampfire.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_directional", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialDirectional.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("has_multiple_faces", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialFaces.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("can_drag", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialDrags.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_bisected", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialHalf.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("has_leaf_size", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialLeafSize.describes(object));
        }, "is_bamboo");
        MaterialTag.registerTag("is_levelable", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialLevel.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_lightable", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialLightable.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_leaves", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialPersistent.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("has_count", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialCount.describes(object));
        }, "is_pickle");
        MaterialTag.registerTag("has_type", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialBlockType.describes(object));
        }, "is_slab");
        MaterialTag.registerTag("is_snowable", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialSnowable.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_switch", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialSwitchFace.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("is_waterloggable", (attribute, object) -> {
            Deprecations.materialPropertyTags.warn(attribute.context);
            return new ElementTag(MaterialWaterlogged.describes(object));
        }, new String[0]);
        MaterialTag.registerTag("has_gravity", (attribute, object) -> new ElementTag(object.material.hasGravity()), new String[0]);
        MaterialTag.registerTag("is_block", (attribute, object) -> new ElementTag(object.material.isBlock()), new String[0]);
        MaterialTag.registerTag("is_item", (attribute, object) -> new ElementTag(object.material.isItem()), new String[0]);
        MaterialTag.registerTag("is_burnable", (attribute, object) -> new ElementTag(object.material.isBurnable()), new String[0]);
        MaterialTag.registerTag("is_edible", (attribute, object) -> new ElementTag(object.material.isEdible()), new String[0]);
        MaterialTag.registerTag("is_flammable", (attribute, object) -> new ElementTag(object.material.isFlammable()), new String[0]);
        MaterialTag.registerTag("is_fuel", (attribute, object) -> new ElementTag(object.material.isFuel()), new String[0]);
        MaterialTag.registerTag("fuel_burn_time", (attribute, object) -> {
            Integer ticks = NMSHandler.getItemHelper().burnTime(object.getMaterial());
            if (ticks != null) {
                return new DurationTag(ticks.longValue());
            }
            return null;
        }, new String[0]);
        MaterialTag.registerTag("is_occluding", (attribute, object) -> new ElementTag(object.material.isOccluding()), new String[0]);
        MaterialTag.registerTag("is_record", (attribute, object) -> new ElementTag(object.material.isRecord()), new String[0]);
        MaterialTag.registerTag("is_solid", (attribute, object) -> new ElementTag(object.material.isSolid()), new String[0]);
        MaterialTag.registerTag("is_switchable", (attribute, object) -> new ElementTag(MaterialSwitchable.describes(object)), new String[0]);
        MaterialTag.registerTag("is_transparent", (attribute, object) -> new ElementTag(object.material.isTransparent()), new String[0]);
        MaterialTag.registerTag("max_durability", (attribute, object) -> new ElementTag(object.material.getMaxDurability()), new String[0]);
        MaterialTag.registerTag("block_resistance", (attribute, object) -> {
            if (!NMSHandler.getBlockHelper().hasBlock(object.getMaterial())) {
                Debug.echoError("Provided material does not have a placeable block.");
                return null;
            }
            return new ElementTag(NMSHandler.getBlockHelper().getBlockResistance(object.getMaterial()));
        }, new String[0]);
        MaterialTag.registerTag("hardness", (attribute, object) -> {
            if (!object.getMaterial().isBlock()) {
                Debug.echoError("Provided material does not have a placeable block.");
                return null;
            }
            return new ElementTag(object.getMaterial().getHardness());
        }, new String[0]);
        MaterialTag.registerTag("max_stack_size", (attribute, object) -> new ElementTag(object.material.getMaxStackSize()), new String[0]);
        MaterialTag.registerTag("translated_name", (attribute, object) -> {
            String key = object.material.getKey().getKey();
            key = key.replace("wall_banner", "banner");
            String type = object.material.isBlock() ? "block" : "item";
            return new ElementTag("\u00a7[translate=" + type + ".minecraft." + key + "]");
        }, new String[0]);
        MaterialTag.registerTag("name", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.material.name())), new String[0]);
        MaterialTag.registerTag("item", (attribute, object) -> {
            ItemTag item = new ItemTag((MaterialTag)object, 1);
            return item;
        }, new String[0]);
        MaterialTag.registerTag("piston_reaction", (attribute, object) -> {
            String res = NMSHandler.getBlockHelper().getPushReaction(object.material);
            if (res == null) {
                return null;
            }
            return new ElementTag(res);
        }, new String[0]);
        MaterialTag.registerTag("block_strength", (attribute, object) -> {
            float res = NMSHandler.getBlockHelper().getBlockStength(object.material);
            return new ElementTag(res);
        }, new String[0]);
        MaterialTag.registerTag("has_vanilla_data_tag", (attribute, object) -> {
            Deprecations.materialHasDataPackTag.warn(attribute.context);
            if (!attribute.hasContext(1)) {
                attribute.echoError("MaterialTag.has_vanilla_data_tag[...] tag must have an input value.");
                return null;
            }
            NamespacedKey key = NamespacedKey.minecraft((String)CoreUtilities.toLowerCase(attribute.getContext(1)));
            Tag tagBlock = Bukkit.getTag((String)"blocks", (NamespacedKey)key, Material.class);
            Tag tagItem = Bukkit.getTag((String)"items", (NamespacedKey)key, Material.class);
            return new ElementTag(tagBlock != null && tagBlock.isTagged((Keyed)object.getMaterial()) || tagItem != null && tagItem.isTagged((Keyed)object.getMaterial()));
        }, new String[0]);
        MaterialTag.registerTag("advanced_matches", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(BukkitScriptEvent.tryMaterial(object, attribute.getContext(1)));
        }, new String[0]);
        MaterialTag.registerTag("vanilla_tags", (attribute, object) -> {
            HashSet<String> tags = VanillaTagHelper.tagsByMaterial.get(object.getMaterial());
            if (tags == null) {
                return new ListTag();
            }
            return new ListTag((Set<?>)tags);
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<MaterialTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.isProperty && mechanism.matches("max_stack_size") && mechanism.requireInteger()) {
            NMSHandler.getItemHelper().setMaxStackSize(this.material, mechanism.getValue().asInt());
        }
        if (!mechanism.isProperty && mechanism.matches("block_resistance") && mechanism.requireFloat() && !NMSHandler.getBlockHelper().setBlockResistance(this.material, mechanism.getValue().asFloat())) {
            Debug.echoError("Provided material does not have a placeable block.");
        }
        if (!mechanism.isProperty && mechanism.matches("block_strength") && mechanism.requireFloat()) {
            if (!this.material.isBlock()) {
                Debug.echoError("'block_strength' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setBlockStrength(this.material, mechanism.getValue().asFloat());
        }
        if (!mechanism.isProperty && mechanism.matches("piston_reaction")) {
            if (!this.material.isBlock()) {
                Debug.echoError("'piston_reaction' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setPushReaction(this.material, mechanism.getValue().asString().toUpperCase());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

