/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class CuboidEnterExitSmartEvent
implements OldSmartEvent,
Listener {
    ArrayList<String> cuboids_to_watch = new ArrayList();
    private boolean broad_detection = false;
    private Map<String, List<dCuboid>> player_cuboids = new ConcurrentHashMap<String, List<dCuboid>>();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        boolean should_register = false;
        this.cuboids_to_watch.clear();
        for (String event : events) {
            Matcher m = Pattern.compile("on player (?:enters|exits) (notable cuboid|(cu@)?\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            boolean registerable = true;
            if (m.group(1).equalsIgnoreCase("notable cuboid")) {
                this.broad_detection = true;
            } else {
                this.cuboids_to_watch.add(CoreUtilities.toLowerCase(m.group(1)));
            }
            should_register = true;
        }
        return should_register;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Cuboid Enter & Exit SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
        PlayerTeleportEvent.getHandlerList().unregister((Listener)this);
        PlayerChangedWorldEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), event.getFrom(), event.getTo());
        this.internalRun(evt, "teleport");
        if (evt.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        double pos = 1.0E7;
        PlayerMoveEvent pme = new PlayerMoveEvent(event.getPlayer(), event.getPlayer().getLocation(), new Location(event.getPlayer().getWorld(), pos, pos, pos));
        this.internalRun(pme, "leave");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        double pos = 1.0E7;
        PlayerMoveEvent pme = new PlayerMoveEvent(event.getPlayer(), new Location(event.getPlayer().getWorld(), pos, pos, pos), event.getPlayer().getLocation());
        this.internalRun(pme, "join");
    }

    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Location to = event.getPlayer().getLocation().clone();
        Location from = event.getPlayer().getLocation().clone();
        from.setWorld(event.getFrom());
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), from, to);
        this.internalRun(evt, "world_change");
    }

    @EventHandler
    public void vehicleMoveEvent(VehicleMoveEvent event) {
        ArrayList<Entity> passengers = new ArrayList<Entity>();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
            passengers.addAll(event.getVehicle().getPassengers());
        } else {
            passengers.add(event.getVehicle().getPassenger());
        }
        for (Entity entity : passengers) {
            if (!dEntity.isPlayer(entity)) continue;
            PlayerMoveEvent evt = new PlayerMoveEvent((Player)entity, event.getFrom(), event.getTo());
            this.internalRun(evt, "vehicle");
        }
    }

    @EventHandler
    public void playerMoveEvent(PlayerMoveEvent event) {
        this.internalRun(event, "walk");
    }

    public void internalRun(PlayerMoveEvent event, String cause) {
        Object cuboid_context;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getTo());
        List<Object> match = new ArrayList();
        String namelow = CoreUtilities.toLowerCase(event.getPlayer().getName());
        if (this.player_cuboids.containsKey(namelow)) {
            match = this.player_cuboids.get(namelow);
        }
        ArrayList exits = new ArrayList(match);
        exits.removeAll(cuboids);
        ArrayList<dCuboid> enters = new ArrayList<dCuboid>(cuboids);
        enters.removeAll(match);
        if (exits.isEmpty() && enters.isEmpty()) {
            return;
        }
        if (!exits.isEmpty()) {
            if (this.broad_detection) {
                cuboid_context = new dList();
                for (dCuboid cuboid : exits) {
                    ((dList)cuboid_context).add(cuboid.identify());
                }
                if (this.Fire(event, (dList)cuboid_context, "player exits notable cuboid", cause)) {
                    return;
                }
            }
            for (dCuboid dCuboid2 : exits) {
                if (!this.Fire(event, new dList(dCuboid2.identify()), "player exits " + dCuboid2.identifySimple(), cause)) continue;
                return;
            }
        }
        if (!enters.isEmpty()) {
            if (this.broad_detection) {
                cuboid_context = new dList();
                for (dCuboid cuboid : enters) {
                    ((dList)cuboid_context).add(cuboid.identify());
                }
                if (this.Fire(event, (dList)cuboid_context, "player enters notable cuboid", cause)) {
                    return;
                }
            }
            for (dCuboid dCuboid3 : enters) {
                if (!this.Fire(event, new dList(dCuboid3.identify()), "player enters " + dCuboid3.identifySimple(), cause)) continue;
                return;
            }
        }
        this.player_cuboids.put(namelow, cuboids);
    }

    private boolean Fire(PlayerMoveEvent event, dList cuboids, String EventName, String cause) {
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("from", new dLocation(event.getFrom()));
        context.put("to", new dLocation(event.getTo()));
        context.put("cuboids", cuboids);
        context.put("cause", new Element(cause));
        events.add(EventName);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
            return true;
        }
        return false;
    }
}

