/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RenameCommand
extends AbstractCommand {
    public static HashMap<UUID, HashMap<UUID, RenameData>> customNames = new HashMap();

    public RenameCommand() {
        this.setName("rename");
        this.setSyntax("rename [<name>/cancel] (t:<entity>|...) (per_player) (for:<player>|...) (list_name_only)");
        this.setRequiredArguments(1, 5);
        this.setParseArgs(false);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("t", "target", "targets")) {
                scriptEntry.addObject("targets", ListTag.getListFor(TagManager.tagObject(arg.getValue(), scriptEntry.getContext()), scriptEntry.getContext()));
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("for")) {
                scriptEntry.addObject("players", ListTag.getListFor(TagManager.tagObject(arg.getValue(), scriptEntry.getContext()), scriptEntry.getContext()).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("per_player") && arg.matches("per_player")) {
                scriptEntry.addObject("per_player", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("list_name_only") && arg.matches("list_name_only")) {
                scriptEntry.addObject("list_name_only", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("name")) {
                scriptEntry.addObject("name", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Must specify a name!");
        }
        if (!scriptEntry.hasObject("targets")) {
            if (Utilities.getEntryNPC(scriptEntry) == null || !Utilities.getEntryNPC(scriptEntry).isValid()) {
                throw new InvalidArgumentsException("Must have an NPC attached, or specify a list of targets to rename!");
            }
            scriptEntry.addObject("targets", new ListTag(Utilities.getEntryNPC(scriptEntry)));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag name = scriptEntry.getElement("name");
        ElementTag perPlayer = scriptEntry.getElement("per_player");
        ElementTag listNameOnly = scriptEntry.getElement("list_name_only");
        ListTag targets = (ListTag)scriptEntry.getObjectTag("targets");
        List players = (List)scriptEntry.getObject("players");
        if (perPlayer != null && perPlayer.asBoolean()) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), name.debug() + targets.debug() + perPlayer.debug() + (listNameOnly != null ? listNameOnly.debug() : "") + (players == null ? "" : ArgumentHelper.debugList("for", players)));
            }
            for (ObjectTag target : targets.objectForms) {
                EntityTag entity = target.asType(EntityTag.class, CoreUtilities.noDebugContext);
                if (entity == null) continue;
                Entity bukkitEntity = entity.getBukkitEntity();
                if (bukkitEntity == null) {
                    Debug.echoError("Invalid entity in rename command.");
                    continue;
                }
                if (name.asString().equals("cancel")) {
                    customNames.remove(bukkitEntity.getUniqueId());
                    if (bukkitEntity.isCustomNameVisible()) {
                        if (players == null) {
                            for (Player player : NMSHandler.getEntityHelper().getPlayersThatSee(bukkitEntity)) {
                                NMSHandler.getPacketHelper().sendRename(player, bukkitEntity, bukkitEntity.getCustomName(), false);
                            }
                            continue;
                        }
                        for (PlayerTag playerTag : players) {
                            NMSHandler.getPacketHelper().sendRename(playerTag.getPlayerEntity(), bukkitEntity, bukkitEntity.getCustomName(), false);
                        }
                        continue;
                    }
                    bukkitEntity.setCustomNameVisible(true);
                    bukkitEntity.setCustomNameVisible(false);
                    continue;
                }
                BukkitTagContext originalContext = (BukkitTagContext)scriptEntry.context.clone();
                HashMap hashMap = customNames.computeIfAbsent(bukkitEntity.getUniqueId(), k -> new HashMap());
                Function<Player, String> nameGetter = p -> {
                    originalContext.player = new PlayerTag((Player)p);
                    return TagManager.tag(name.asString(), originalContext);
                };
                RenameData renamer = new RenameData();
                renamer.nameFunction = nameGetter;
                boolean bl = renamer.listOnly = listNameOnly != null && listNameOnly.asBoolean();
                if (players == null) {
                    hashMap.put(null, renamer);
                } else {
                    for (PlayerTag playerTag : players) {
                        hashMap.put(playerTag.getUUID(), renamer);
                    }
                }
                if (players == null) {
                    for (Player player : NMSHandler.getEntityHelper().getPlayersThatSee(bukkitEntity)) {
                        NMSHandler.getPacketHelper().sendRename(player, bukkitEntity, "", renamer.listOnly);
                    }
                    continue;
                }
                for (PlayerTag playerTag : players) {
                    NMSHandler.getPacketHelper().sendRename(playerTag.getPlayerEntity(), bukkitEntity, "", renamer.listOnly);
                }
            }
            return;
        }
        String nameString = TagManager.tag(name.asString(), scriptEntry.context);
        if (nameString.length() > 256) {
            nameString = nameString.substring(0, 256);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("name", nameString) + (listNameOnly != null ? listNameOnly.debug() : "") + targets.debug());
        }
        for (ObjectTag target : targets.objectForms) {
            EntityFormObject entity = target.asType(EntityTag.class, CoreUtilities.noDebugContext);
            entity = entity == null ? (EntityFormObject)target.asType(NPCTag.class, scriptEntry.context) : ((EntityTag)entity).getDenizenObject();
            if (entity == null) {
                Debug.echoError("Invalid entity in rename command.");
                continue;
            }
            if (entity instanceof NPCTag) {
                NPC npc = ((NPCTag)entity).getCitizen();
                if (npc.isSpawned()) {
                    Location location = npc.getEntity().getLocation();
                    npc.despawn(DespawnReason.PENDING_RESPAWN);
                    npc.setName(nameString);
                    npc.spawn(location);
                    continue;
                }
                npc.setName(nameString);
                continue;
            }
            if (entity instanceof PlayerTag) {
                if (listNameOnly != null && listNameOnly.asBoolean()) {
                    AdvancedTextImpl.instance.setPlayerListName(((PlayerTag)entity).getPlayerEntity(), nameString);
                    continue;
                }
                String limitedName = nameString.length() > 16 ? nameString.substring(0, 16) : nameString;
                NMSHandler.getInstance().getProfileEditor().setPlayerName(((PlayerTag)entity).getPlayerEntity(), limitedName);
                continue;
            }
            Entity bukkitEntity = entity.getDenizenEntity().getBukkitEntity();
            customNames.remove(bukkitEntity.getUniqueId());
            bukkitEntity.setCustomName(nameString);
            bukkitEntity.setCustomNameVisible(true);
        }
    }

    public static boolean hasAnyDynamicRenames() {
        return !customNames.isEmpty();
    }

    public static void addDynamicRename(Entity bukkitEntity, Player forPlayer, RenameData rename) {
        HashMap playerToFuncMap = customNames.computeIfAbsent(bukkitEntity.getUniqueId(), k -> new HashMap());
        playerToFuncMap.put(forPlayer == null ? null : forPlayer.getUniqueId(), rename);
        if (forPlayer == null) {
            for (Player player : NMSHandler.getEntityHelper().getPlayersThatSee(bukkitEntity)) {
                NMSHandler.getPacketHelper().sendRename(player, bukkitEntity, "", rename.listOnly);
            }
        } else {
            NMSHandler.getPacketHelper().sendRename(forPlayer, bukkitEntity, "", rename.listOnly);
        }
    }

    public static String getCustomNameFor(UUID entityId, Player player, boolean isForList) {
        HashMap<UUID, RenameData> map = customNames.get(entityId);
        if (map == null) {
            return null;
        }
        RenameData rename = map.get(player.getUniqueId());
        if ((rename == null || rename.listOnly && !isForList) && ((rename = map.get(null)) == null || rename.listOnly && !isForList)) {
            return null;
        }
        return rename.nameFunction.apply(player);
    }

    public static class RenameData {
        public Function<Player, String> nameFunction;
        public boolean listOnly;
    }
}

