/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.FakeOfflinePlayer;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardCommand
extends AbstractCommand {
    public ScoreboardCommand() {
        this.setName("scoreboard");
        this.setSyntax("scoreboard ({add}/remove) (viewers:<player>|...) (lines:<player>/<text>|...) (id:<value>/player/{main}) (objective:<value>) (criteria:<criteria>/{dummy}) (score:<#>) (displayslot:<value>/{sidebar}/none) (displayname:<name>)");
        this.setRequiredArguments(1, 9);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("lines", "l")) {
                scriptEntry.addObject("lines", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("objective") && arg.matchesPrefix("objective", "obj", "o")) {
                scriptEntry.addObject("objective", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("criteria") && arg.matchesPrefix("criteria", "c")) {
                scriptEntry.addObject("criteria", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("score") && arg.matchesInteger()) {
                scriptEntry.addObject("score", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("displayslot") && (arg.matchesEnum((Enum<?>[])DisplaySlot.values()) || arg.matches("none"))) {
                scriptEntry.addObject("displayslot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("displayslot") && arg.matchesPrefix("displayname")) {
                scriptEntry.addObject("displayname", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("viewers") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("viewers", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new ElementTag("add"));
        scriptEntry.defaultObject("id", new ElementTag("main"));
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        if (PlayerTag.playerNameIsValid(name)) {
            return Bukkit.getOfflinePlayer((String)name);
        }
        return new FakeOfflinePlayer(name);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Objective obj;
        boolean hadDisplaySlot;
        List viewers = (List)scriptEntry.getObject("viewers");
        ListTag lines = scriptEntry.hasObject("lines") ? ListTag.valueOf(scriptEntry.getElement("lines").asString(), scriptEntry.getContext()) : new ListTag();
        ElementTag action = scriptEntry.getElement("action");
        ElementTag id = scriptEntry.getElement("id");
        ElementTag objective = scriptEntry.getElement("objective");
        ElementTag criteria = scriptEntry.getElement("criteria");
        ElementTag score = scriptEntry.getElement("score");
        ElementTag displaySlot = scriptEntry.getElement("displayslot");
        ElementTag displayName = scriptEntry.getElement("displayname");
        Action act = Action.valueOf(action.asString().toUpperCase());
        boolean hadCriteria = criteria != null;
        boolean bl = hadDisplaySlot = displaySlot != null;
        if (!hadCriteria) {
            criteria = new ElementTag("dummy");
        }
        if (!hadDisplaySlot) {
            displaySlot = new ElementTag("sidebar");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), action.debug() + id.debug() + (viewers != null ? ArgumentHelper.debugObj("viewers", viewers.toString()) : "") + (objective != null ? objective.debug() : "") + (!lines.isEmpty() ? lines.debug() : "") + (!act.equals((Object)Action.ADD) ? "" : (score == null ? "" : score.debug()) + (objective == null ? "" : displaySlot.debug() + criteria.debug() + (displayName == null ? "" : displayName.debug()))));
        }
        Scoreboard board = null;
        if (id.asString().equalsIgnoreCase("main")) {
            board = ScoreboardHelper.getMain();
        } else if (id.asString().equalsIgnoreCase("player")) {
            board = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getScoreboard();
        } else if (ScoreboardHelper.hasScoreboard(id.asString())) {
            board = ScoreboardHelper.getScoreboard(id.asString());
        } else if (act.equals((Object)Action.ADD)) {
            board = ScoreboardHelper.createScoreboard(id.asString());
        }
        if (board == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Scoreboard " + id.asString() + " does not exist!");
            return;
        }
        if (act.equals((Object)Action.ADD)) {
            if (objective != null) {
                boolean existedAlready;
                obj = board.getObjective(objective.asString());
                boolean bl2 = existedAlready = obj != null;
                if (obj == null) {
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                } else if (hadCriteria && !obj.getCriteria().equals(criteria.asString())) {
                    obj.unregister();
                    obj = board.registerNewObjective(objective.asString(), criteria.asString());
                }
                if (!(existedAlready && !hadDisplaySlot || displaySlot.asString().equalsIgnoreCase("none"))) {
                    obj.setDisplaySlot(DisplaySlot.valueOf((String)displaySlot.asString().toUpperCase()));
                }
                if (displayName != null) {
                    obj.setDisplayName(displayName.asString());
                } else if (!existedAlready) {
                    obj.setDisplayName(objective.asString());
                }
                if (!lines.isEmpty()) {
                    if (score == null) {
                        score = new ElementTag(0);
                    }
                    for (String line : lines) {
                        if ((line = line.replaceAll("[pP]@", "")).length() > 48) {
                            line = line.substring(0, 48);
                        }
                        ScoreboardHelper.addScore(obj, ScoreboardCommand.getOfflinePlayer(line), score.asInt());
                    }
                }
            } else if (viewers == null && !lines.isEmpty()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Cannot add lines without specifying an objective!");
            }
        } else if (act.equals((Object)Action.REMOVE)) {
            if (objective != null) {
                obj = board.getObjective(objective.asString());
                if (obj != null) {
                    if (lines.isEmpty()) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Removing objective " + obj.getName() + " from scoreboard " + id.asString());
                        obj.unregister();
                    } else {
                        for (String line : lines) {
                            line = line.replaceAll("[pP]@", "");
                            ScoreboardHelper.removeScore(obj, ScoreboardCommand.getOfflinePlayer(line));
                        }
                    }
                } else {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Objective " + objective.asString() + " does not exist in scoreboard " + id.asString());
                }
            } else if (!lines.isEmpty()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Removing lines " + lines.identify() + " from all objectives in scoreboard " + id.asString());
                for (String line : lines) {
                    line = line.replaceAll("[pP]@", "");
                    ScoreboardHelper.removePlayer(id.asString(), ScoreboardCommand.getOfflinePlayer(line));
                }
            } else if (viewers == null) {
                Debug.echoDebug((Debuggable)scriptEntry, "Removing scoreboard " + id.asString());
                ScoreboardHelper.deleteScoreboard(id.asString());
            }
        }
        if (viewers != null) {
            for (PlayerTag viewer : viewers) {
                if (act.equals((Object)Action.ADD)) {
                    if (!id.asString().equalsIgnoreCase("main")) {
                        ScoreboardHelper.viewerMap.put(viewer.getName(), id.asString());
                    }
                    if (!viewer.isOnline()) continue;
                    viewer.getPlayerEntity().setScoreboard(board);
                    continue;
                }
                if (!act.equals((Object)Action.REMOVE)) continue;
                ScoreboardHelper.viewerMap.remove(viewer.getName());
                if (!viewer.isOnline()) continue;
                viewer.getPlayerEntity().setScoreboard(ScoreboardHelper.createScoreboard());
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

