/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class BiomeEnterExitScriptEvent
extends ScriptEvent
implements Listener {
    public static BiomeEnterExitScriptEvent instance;
    public dLocation from;
    public dLocation to;
    public Element old_biome;
    public Element new_biome;
    public PlayerMoveEvent event;

    public BiomeEnterExitScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player enters") || lower.startsWith("player exits");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String biome_test = lower.substring(lower.lastIndexOf(32) + 1);
        String direction = lower.substring(lower.indexOf(32) + 1, lower.lastIndexOf(32)).trim();
        return biome_test.equals("biome") || direction.equals("enters") && biome_test.equals(CoreUtilities.toLowerCase(this.new_biome.toString())) || direction.equals("exits") && biome_test.equals(CoreUtilities.toLowerCase(this.old_biome.toString()));
    }

    @Override
    public String getName() {
        return "BiomeEnterExit";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("to")) {
            return this.to;
        }
        if (name.equals("from")) {
            return this.from;
        }
        if (name.equals("old_biome")) {
            return this.old_biome;
        }
        if (name.equals("new_biome")) {
            return this.new_biome;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEntersExitsBiome(PlayerMoveEvent event) {
        this.from = new dLocation(event.getFrom());
        this.to = new dLocation(event.getTo());
        this.old_biome = new Element(this.from.getBlock().getBiome().name());
        this.new_biome = new Element(this.to.getBlock().getBiome().name());
        if (this.old_biome.identify().equals(this.new_biome.identify())) {
            return;
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

