/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.plugin.Plugin;

public class LiquidSpreadScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LiquidSpreadScriptEvent instance;
    public dMaterial material;
    public dLocation location;
    public dLocation destination;
    public BlockFromToEvent event;

    public LiquidSpreadScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "spreads") && !lower.startsWith("block");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String mat = CoreUtilities.getXthArg(0, lower);
        return !(!mat.equals("liquid") && !this.tryMaterial(this.material, mat) || !this.runInCheck(path, this.location) && !this.runInCheck(path, this.destination));
    }

    @Override
    public String getName() {
        return "LiquidSpreads";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockFromToEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("destination")) {
            return this.destination;
        }
        if (name.equals("material")) {
            return this.material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLiquidSpreads(BlockFromToEvent event) {
        this.destination = new dLocation(event.getToBlock().getLocation());
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

