/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.helpers.PacketHelper_v1_8_R3;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BossBar_v1_8_R3 {
    private static final Map<String, Boolean> hasHealthBar = new HashMap<String, Boolean>();
    private static final List<Player> playersWithHealthBar = new ArrayList<Player>();
    private static final HashSet<Material> ignoreAllBlocks = new HashSet<Material>(EnumSet.allOf(Material.class));
    private static final BukkitTask task = new BukkitRunnable(){

        public void run() {
            for (int i = 0; i < playersWithHealthBar.size(); ++i) {
                Player player = (Player)playersWithHealthBar.get(i);
                if (!player.isDead() && player.isValid()) {
                    Location location = player.getLocation().clone();
                    location.add(player.getLocation().getDirection().multiply(30));
                    wither.setPosition(location.getX(), location.getY(), location.getZ());
                    PacketHelper_v1_8_R3.sendPacket(player, (Packet)new PacketPlayOutEntityTeleport((Entity)wither));
                    continue;
                }
                hasHealthBar.put(player.getName(), false);
                playersWithHealthBar.remove(player);
            }
        }
    }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 20L, 20L);
    private static final EntityWither wither = new EntityWither((World)((CraftWorld)Bukkit.getWorlds().get(0)).getHandle());

    public static void showBossBar(Player player, String text, int health) {
        wither.setCustomName(text);
        wither.setHealth((float)health);
        Location location = player.getLocation().clone();
        location.add(player.getLocation().getDirection().multiply(30));
        wither.setPosition(location.getX(), location.getY(), location.getZ());
        PacketHelper_v1_8_R3.sendPacket(player, (Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)wither));
        hasHealthBar.put(player.getName(), true);
        playersWithHealthBar.add(player);
    }

    public static void removeBossBar(Player player) {
        if (hasHealthBar.containsKey(player.getName())) {
            PacketHelper_v1_8_R3.sendPacket(player, (Packet)new PacketPlayOutEntityDestroy(new int[]{wither.getId()}));
            hasHealthBar.put(player.getName(), false);
            playersWithHealthBar.remove(player);
        }
    }

    static {
        wither.b(true);
        wither.setInvisible(true);
        wither.setCustomNameVisible(true);
    }
}

