/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Location;

public class dEllipsoid
implements dObject,
Notable {
    private dLocation loc;
    private dLocation size;
    String prefix = "ellipsoid";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static List<dEllipsoid> getNotableEllipsoidsContaining(Location location) {
        ArrayList<dEllipsoid> cuboids = new ArrayList<dEllipsoid>();
        for (dEllipsoid ellipsoid : NotableManager.getAllType(dEllipsoid.class)) {
            if (!ellipsoid.contains(location)) continue;
            cuboids.add(ellipsoid);
        }
        return cuboids;
    }

    public static dEllipsoid valueOf(String string) {
        return dEllipsoid.valueOf(string, null);
    }

    @Fetchable(value="ellipsoid")
    public static dEllipsoid valueOf(String string, TagContext context) {
        if (string.startsWith("ellipsoid@")) {
            string = string.substring(10);
        }
        if (NotableManager.isType(string, dEllipsoid.class)) {
            return (dEllipsoid)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 7) {
            return null;
        }
        dWorld world = dWorld.valueOf(split.get(3), false);
        if (world == null) {
            return null;
        }
        dLocation location = new dLocation(world.getWorld(), aH.getDoubleFrom(split.get(0)), aH.getDoubleFrom(split.get(1)), aH.getDoubleFrom(split.get(2)));
        dLocation size = new dLocation(null, aH.getDoubleFrom(split.get(4)), aH.getDoubleFrom(split.get(5)), aH.getDoubleFrom(split.get(6)));
        return new dEllipsoid(location, size);
    }

    public static boolean matches(String arg) {
        try {
            return dEllipsoid.valueOf(arg) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public dEllipsoid(dLocation loc, dLocation size) {
        this.loc = loc;
        this.size = size;
    }

    public dList getBlocks() {
        return this.getBlocks(null);
    }

    public dList getBlocks(List<dMaterial> materials) {
        List<dLocation> initial = new dCuboid(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(materials);
        dList list = new dList();
        for (dLocation loc : initial) {
            if (!this.contains(loc)) continue;
            list.add(loc.identify());
        }
        return list;
    }

    public List<dLocation> getBlockLocations() {
        List<dLocation> initial = new dCuboid(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(null);
        ArrayList<dLocation> locations = new ArrayList<dLocation>();
        for (dLocation loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    public boolean contains(Location test) {
        double xbase = test.getX() - this.loc.getX();
        double ybase = test.getY() - this.loc.getY();
        double zbase = test.getZ() - this.loc.getZ();
        return xbase * xbase / (this.size.getX() * this.size.getX()) + ybase * ybase / (this.size.getY() * this.size.getY()) + zbase * zbase / (this.size.getZ() * this.size.getZ()) < 1.0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    @Note(value="Ellipsoids")
    public Object getSaveObject() {
        return this.identifyFull().substring(10);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "Ellipsoid";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "ellipsoid@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        return "ellipsoid@" + this.loc.getX() + "," + this.loc.getY() + "," + this.loc.getZ() + "," + this.loc.getWorld().getName() + "," + this.size.getX() + "," + this.size.getY() + "," + this.size.getZ();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        dEllipsoid.registerTag("blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (attribute.hasContext(1)) {
                    return new dList(((dEllipsoid)object).getBlocks(dList.valueOf(attribute.getContext(1)).filter(dMaterial.class))).getAttribute(attribute.fulfill(1));
                }
                return new dList(((dEllipsoid)object).getBlocks()).getAttribute(attribute.fulfill(1));
            }
        });
        dEllipsoid.registerTag("get_blocks", registeredTags.get("blocks"));
        dEllipsoid.registerTag("location", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return ((dEllipsoid)object).loc.getAttribute(attribute.fulfill(1));
            }
        });
        dEllipsoid.registerTag("size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return ((dEllipsoid)object).size.getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

