/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.function.Consumer;

public class LightCommand
extends AbstractCommand {
    public LightCommand() {
        this.setName("light");
        this.setSyntax("light [<location>] [<#>/reset] (duration:<duration>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Notable note : NotableManager.notesByType.get(LocationTag.class)) {
            addOne.accept(NotableManager.getSavedId(note));
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("light") && arg.matchesInteger()) {
                scriptEntry.addObject("light", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("reset") && arg.matches("reset")) {
                scriptEntry.addObject("reset", new ElementTag(true));
                continue;
            }
            if (scriptEntry.hasObject("duration") || !arg.matchesPrefix("d", "duration") || !arg.matchesArgumentType(DurationTag.class)) continue;
            scriptEntry.addObject("duration", arg.asType(DurationTag.class));
        }
        if (!scriptEntry.hasObject("location") || !scriptEntry.hasObject("light") && !scriptEntry.hasObject("reset")) {
            throw new InvalidArgumentsException("Must specify a valid location and light level.");
        }
        scriptEntry.defaultObject("reset", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag light = scriptEntry.getElement("light");
        ElementTag reset = scriptEntry.getElement("reset");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), location.debug() + reset.debug() + (light != null ? light.debug() : "") + (duration != null ? duration.debug() : ""));
        }
        if (!Utilities.isLocationYSafe(location)) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Invalid light location!");
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                location.clone().add(x * 16, 0.0, z * 16).getChunk().load();
            }
        }
        if (!reset.asBoolean()) {
            int brightness = light.asInt();
            if (brightness < 0 || brightness > 15) {
                Debug.echoError("Light brightness must be between 0 and 15, inclusive!");
                return;
            }
            NMSHandler.getInstance().createBlockLight(location, brightness, duration == null ? 0L : duration.getTicks());
        } else {
            BlockLight.removeLight(location);
        }
    }
}

