/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.world.PortalCreateEvent;

public interface BlockHelper {
    public void applyPhysics(Location var1);

    public PlayerProfile getPlayerProfile(Skull var1);

    public void setPlayerProfile(Skull var1, PlayerProfile var2);

    public CompoundTag getNbtData(Block var1);

    public void setNbtData(Block var1, CompoundTag var2);

    public boolean hasBlock(Material var1);

    public boolean setBlockResistance(Material var1, float var2);

    public float getBlockResistance(Material var1);

    public BlockState generateBlockState(Block var1, Material var2);

    public List<Location> getBlocksList(PortalCreateEvent var1);

    public String getPushReaction(Material var1);

    public void setPushReaction(Material var1, String var2);

    public float getBlockStength(Material var1);

    public void setBlockStrength(Material var1, float var2);

    public static String getMaterialNameFromBlockData(String text) {
        int openBracket = text.indexOf(91);
        String material = text;
        if (openBracket > 0) {
            material = text.substring(0, openBracket);
        }
        if (material.startsWith("minecraft:")) {
            material = material.substring("minecraft:".length());
        }
        return material;
    }

    default public BlockData parseBlockData(String text) {
        int openBracket = text.indexOf(91);
        String material = text;
        String otherData = null;
        if (openBracket > 0) {
            material = text.substring(0, openBracket);
            otherData = text.substring(openBracket);
        }
        if (material.startsWith("minecraft:")) {
            material = material.substring("minecraft:".length());
        }
        return this.parseBlockData(Material.getMaterial((String)material.toUpperCase()), otherData);
    }

    public BlockData parseBlockData(Material var1, String var2);

    default public void makeBlockStateRaw(BlockState state) {
        throw new UnsupportedOperationException();
    }

    default public void doRandomTick(Location location) {
        throw new UnsupportedOperationException();
    }
}

