/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.vehicle;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public class VehicleDestroyedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleDestroyedScriptEvent instance;
    public EntityTag vehicle;
    public EntityTag entity;
    public VehicleDestroyEvent event;

    public VehicleDestroyedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("destroys")) {
            if (!this.couldMatchEntity(path.eventArgLowerAt(0))) {
                return false;
            }
            if (!this.exactMatchesVehicle(path.eventArgLowerAt(2))) {
                return false;
            }
        } else if (cmd.equals("destroyed")) {
            if (!this.exactMatchesVehicle(path.eventArgLowerAt(0))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String ent;
        String cmd = path.eventArgLowerAt(1);
        String veh = cmd.equals("destroyed") ? path.eventArgLowerAt(0) : path.eventArgLowerAt(2);
        String string = ent = cmd.equals("destroys") ? path.eventArgLowerAt(0) : "";
        if (!VehicleDestroyedScriptEvent.tryEntity(this.vehicle, veh)) {
            return false;
        }
        if (!(ent.length() <= 0 || this.entity != null && VehicleDestroyedScriptEvent.tryEntity(this.entity, ent))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "VehicleDestroyed";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleDestroyed(VehicleDestroyEvent event) {
        this.vehicle = new EntityTag((Entity)event.getVehicle());
        this.entity = event.getAttacker() != null ? new EntityTag(event.getAttacker()) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

