/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class PlayerCraftsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerCraftsItemScriptEvent instance;
    public boolean resultChanged;
    public dItem result;
    public dList recipe;
    public CraftingInventory inventory;
    public dPlayer player;

    public PlayerCraftsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.getXthArg(0, lower).equals("player") && CoreUtilities.getXthArg(1, lower).equals("crafts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        String eItem = CoreUtilities.getXthArg(2, lower);
        return this.tryItem(this.result, eItem);
    }

    @Override
    public String getName() {
        return "PlayerCraftsItem";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        CraftItemEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.result = dItem.valueOf(determination);
            this.resultChanged = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("inventory")) {
            return dInventory.mirrorBukkitInventory((Inventory)this.inventory);
        }
        if (name.equals("recipe")) {
            return this.recipe;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (dEntity.isNPC((Entity)humanEntity)) {
            return;
        }
        Recipe eRecipe = event.getRecipe();
        if (eRecipe == null || eRecipe.getResult() == null) {
            return;
        }
        this.inventory = event.getInventory();
        this.result = new dItem(eRecipe.getResult());
        this.recipe = new dList();
        for (ItemStack itemStack : this.inventory.getMatrix()) {
            if (itemStack != null) {
                this.recipe.add(new dItem(itemStack).identify());
                continue;
            }
            this.recipe.add(new dItem(Material.AIR).identify());
        }
        this.player = dEntity.getPlayerFrom((Entity)humanEntity);
        this.resultChanged = false;
        this.cancelled = false;
        this.fire();
        if (this.cancelled) {
            event.setCancelled(true);
        } else if (this.resultChanged) {
            event.setCurrentItem(this.result.getItemStack());
        }
    }
}

