/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.NaturalOrderComparator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;

public class ListTag
implements List<String>,
ObjectTag {
    public static AsciiMatcher needsEscpingMatcher = new AsciiMatcher("&|");
    public final ArrayList<ObjectTag> objectForms;
    public boolean wasLegacy = false;
    private String prefix = "List";
    public static ObjectTagProcessor<ListTag> tagProcessor = new ObjectTagProcessor();

    public static String escapeEntry(String value) {
        if (!needsEscpingMatcher.containsAnyMatch(value)) {
            return value;
        }
        return value.replace("&", "&amp").replace("|", "&pipe");
    }

    public static String unescapeEntry(String value) {
        if (value.indexOf(38) == -1) {
            return value;
        }
        return value.replace("&pipe", "|").replace("&amp", "&");
    }

    @Override
    public boolean add(String addMe) {
        return this.objectForms.add(new ElementTag(addMe));
    }

    @Override
    public void add(int index, String addMe) {
        this.objectForms.add(index, new ElementTag(addMe));
    }

    @Override
    public boolean addAll(Collection<? extends String> addMe) {
        for (String string : addMe) {
            this.add(string);
        }
        return !addMe.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        for (String string : c) {
            this.add(index++, string);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean allGone = true;
        for (Object obj : c) {
            if (this.remove(obj)) continue;
            allGone = false;
        }
        return allGone;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.objectForms.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return new ListTagStringIterator(this, index);
    }

    @Override
    public Object[] toArray() {
        Object[] stringArr = new Object[this.size()];
        for (int i = 0; i < stringArr.length; ++i) {
            stringArr[i] = String.valueOf(this.getObject(i));
        }
        return stringArr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i;
        String[] stringArr = a instanceof String[] && a.length >= this.size() ? (String[])a : new String[this.size()];
        for (i = 0; i < this.size(); ++i) {
            stringArr[i] = String.valueOf(this.getObject(i));
        }
        for (i = this.size(); i < stringArr.length; ++i) {
            stringArr[i] = null;
        }
        return stringArr;
    }

    public ListTag subList(int fromIndex, int toIndex) {
        return new ListTag((Collection<? extends ObjectTag>)this.objectForms.subList(fromIndex, toIndex));
    }

    @Override
    public int indexOf(Object obj) {
        int size = this.size();
        if (obj == null) {
            for (int i = 0; i < size; ++i) {
                if (this.getObject(i) != null) continue;
                return i;
            }
        } else if (obj instanceof String) {
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(String.valueOf(this.getObject(i)))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(this.getObject(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        int size = this.size() - 1;
        if (obj == null) {
            for (int i = size; i >= 0; --i) {
                if (this.getObject(i) != null) continue;
                return i;
            }
        } else if (obj instanceof String) {
            for (int i = size; i >= 0; --i) {
                if (!obj.equals(String.valueOf(this.getObject(i)))) continue;
                return i;
            }
        } else {
            for (int i = size; i >= 0; --i) {
                if (!obj.equals(this.getObject(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public ObjectTag removeObject(int index) {
        return this.objectForms.remove(index);
    }

    @Override
    public String remove(int index) {
        return String.valueOf(this.removeObject(index));
    }

    @Override
    public boolean remove(Object key) {
        int ind = this.indexOf(key);
        if (ind < 0 || ind >= this.size()) {
            return false;
        }
        this.remove(ind);
        return true;
    }

    @Override
    public int size() {
        return this.objectForms.size();
    }

    @Override
    public boolean isEmpty() {
        return this.objectForms.isEmpty();
    }

    @Override
    public boolean isTruthy() {
        return !this.isEmpty();
    }

    @Override
    public String get(int index) {
        return String.valueOf(this.objectForms.get(index));
    }

    @Override
    public String set(int index, String value) {
        return String.valueOf(this.setObject(index, new ElementTag(value)));
    }

    public boolean addAll(ListTag inp) {
        return this.objectForms.addAll(inp.objectForms);
    }

    public boolean addObject(ObjectTag obj) {
        return this.objectForms.add(obj);
    }

    public void addObject(int index, ObjectTag obj) {
        this.objectForms.add(index, obj);
    }

    public ObjectTag setObject(int index, ObjectTag obj) {
        return this.objectForms.set(index, obj);
    }

    public ObjectTag getObject(int id) {
        return this.objectForms.get(id);
    }

    @Deprecated
    public static ListTag valueOf(String string) {
        return ListTag.valueOf(string, null);
    }

    @Fetchable(value="li")
    public static ListTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("map@")) {
            MapTag map = MapTag.valueOf(string, context);
            ListTag list = new ListTag();
            if (map == null) {
                list.add(string);
            } else {
                list.addObject(map);
            }
            return list;
        }
        return new ListTag(string.startsWith("li@") ? string.substring("li@".length()) : string, context);
    }

    public static ListTag getListFor(ObjectTag inp, TagContext context) {
        if (inp instanceof ListTag) {
            return (ListTag)inp;
        }
        if (inp instanceof ElementTag) {
            return ListTag.valueOf(inp.toString(), context);
        }
        ListTag output = new ListTag(1);
        output.addObject(inp);
        return output;
    }

    public static boolean matches(String arg) {
        return arg.contains("|") || arg.startsWith("li@");
    }

    @Override
    public ListTag duplicate() {
        ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(this.size());
        for (ObjectTag obj : this.objectForms) {
            objs.add(obj == null ? null : obj.duplicate());
        }
        ListTag result = new ListTag((Collection<? extends ObjectTag>)objs);
        return result;
    }

    public ListTag(Collection<? extends ObjectTag> objectTagList) {
        this.objectForms = new ArrayList<ObjectTag>(objectTagList);
    }

    public ListTag(ObjectTag ... objects) {
        this((Collection<? extends ObjectTag>)Arrays.asList(objects));
    }

    public ListTag(int capacity) {
        this.objectForms = new ArrayList(capacity);
    }

    public ListTag() {
        this.objectForms = new ArrayList();
    }

    public ListTag(String items) {
        this(items, null);
    }

    public ListTag(String items, TagContext context) {
        this.objectForms = new ArrayList();
        if (items != null && items.length() > 0) {
            if (!items.contains("|")) {
                this.addObject(ObjectFetcher.pickObjectFor(items, context));
            } else if (items.endsWith("|")) {
                int pipe = items.indexOf(124);
                int lastPipe = 0;
                while (pipe != -1) {
                    String value = ListTag.unescapeEntry(items.substring(lastPipe, pipe));
                    ObjectTag object = ObjectFetcher.pickObjectFor(value, context);
                    this.addObject(object);
                    lastPipe = pipe + 1;
                    pipe = items.indexOf(124, lastPipe);
                }
            } else {
                this.wasLegacy = true;
                int brackets = 0;
                int start = 0;
                for (int i = 0; i < items.length(); ++i) {
                    char chr = items.charAt(i);
                    if (chr == '[') {
                        ++brackets;
                        continue;
                    }
                    if (chr == ']') {
                        if (brackets <= 0) continue;
                        --brackets;
                        continue;
                    }
                    if (brackets != 0 || chr != '|') continue;
                    this.addObject(ObjectFetcher.pickObjectFor(items.substring(start, i), context));
                    start = i + 1;
                }
                if (start < items.length()) {
                    this.addObject(ObjectFetcher.pickObjectFor(items.substring(start), context));
                }
            }
        }
    }

    public ListTag(ListTag input) {
        this.objectForms = new ArrayList<ObjectTag>(input.objectForms);
    }

    public ListTag(List<String> items, boolean isPlainText) {
        this.objectForms = new ArrayList(items.size());
        for (String str : items) {
            this.objectForms.add(new ElementTag(str, isPlainText));
        }
    }

    public ListTag(List<String> items) {
        this.objectForms = new ArrayList(items.size());
        for (String str : items) {
            this.objectForms.add(new ElementTag(str));
        }
    }

    public ListTag(Set<?> items) {
        this.objectForms = new ArrayList(items.size());
        for (Object o : items) {
            if (o instanceof ObjectTag) {
                this.objectForms.add((ObjectTag)o);
                continue;
            }
            this.objectForms.add(new ElementTag(o.toString()));
        }
    }

    public ListTag addObjects(List<ObjectTag> objectTags) {
        this.objectForms.addAll(objectTags);
        return this;
    }

    public boolean containsObjectsFrom(Class<? extends ObjectTag> dClass) {
        for (ObjectTag testable : this.objectForms) {
            if (!CoreUtilities.canPossiblyBeType(testable, dClass)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>(values.length);
        for (String string : this) {
            for (Enum value : values) {
                if (!CoreUtilities.equalsIgnoreCase(value.name(), string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        return this.filter(dClass, entry == null ? CoreUtilities.basicContext : entry.entryData.getTagContext(), true);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, Debuggable debugger, boolean showFailure) {
        TagContext context = DenizenCore.getImplementation().getTagContext((ScriptEntry)null);
        context.debug = debugger.shouldDebug();
        return this.filter(dClass, context, showFailure);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context) {
        return this.filter(dClass, context, context == null || context.debug);
    }

    public <T extends ObjectTag> List<T> filter(Class<T> dClass, TagContext context, boolean showFailure) {
        ArrayList<T> results = new ArrayList<T>(this.objectForms.size());
        for (ObjectTag obj : this.objectForms) {
            try {
                if (CoreUtilities.canPossiblyBeType(obj, dClass)) {
                    T object = CoreUtilities.asType(obj, dClass, context);
                    if (object != null) {
                        results.add(object);
                        continue;
                    }
                    if (!showFailure) continue;
                    Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (conversion returned null).");
                    continue;
                }
                if (!showFailure) continue;
                Debug.echoError("Cannot process list-entry '" + obj + "' as type '" + dClass.getSimpleName() + "' (does not match expected type).");
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return results;
    }

    public ListTag deduplicate() {
        ListTag list = new ListTag();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String entry = this.get(i);
            boolean duplicate = false;
            for (int x = 0; x < i; ++x) {
                if (!CoreUtilities.equalsIgnoreCase(this.get(x), entry)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            list.addObject(this.objectForms.get(i));
        }
        return list;
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ListTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("<G>li@<Y> ");
        for (ObjectTag item : this.objectForms) {
            debugText.append(item.debuggable()).append(" <G>|<Y> ");
        }
        return debugText.substring(0, debugText.length() - " <G>|<Y> ".length());
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        return this.identifyList();
    }

    public String identifyList() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder output = new StringBuilder();
        output.append("li@");
        for (ObjectTag object : this.objectForms) {
            output.append(ListTag.escapeEntry(object.savable())).append('|');
        }
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    private static String parseString(ListTag obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - spacer.length());
    }

    public int parseIndex(String index) {
        if (CoreUtilities.equalsIgnoreCase(index, "last")) {
            return this.size() - 1;
        }
        if (CoreUtilities.equalsIgnoreCase(index, "first")) {
            return 0;
        }
        return new ElementTag(index).asInt() - 1;
    }

    public static void registerTags() {
        ListTag.registerTag("combine", (attribute, object) -> {
            ListTag output = new ListTag();
            for (ObjectTag obj : object.objectForms) {
                output.addObjects(ListTag.getListFor((ObjectTag)obj, (TagContext)attribute.context).objectForms);
            }
            return output;
        }, new String[0]);
        ListTag.registerTag("sub_lists", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("list.sub_lists[...] tag must have an input.");
                return null;
            }
            int subListLength = Math.max(1, attribute.getIntContext(1));
            ListTag output = new ListTag();
            ListTag building = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                building.addObject(object.getObject(i));
                if (building.size() != subListLength) continue;
                output.addObject(building);
                building = new ListTag();
            }
            if (!building.isEmpty()) {
                output.addObject(building);
            }
            return output;
        }, new String[0]);
        ListTag.registerTag("space_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, " "));
        }, "as_string", "asstring");
        ListTag.registerTag("separated_by", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            String input = attribute.getContext(1);
            return new ElementTag(ListTag.parseString(object, input));
        }, new String[0]);
        ListTag.registerTag("comma_separated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ", "));
        }, "ascslist", "as_cslist");
        ListTag.registerTag("unseparated", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            return new ElementTag(ListTag.parseString(object, ""));
        }, new String[0]);
        ListTag.registerTag("get_sub_items", (attribute, object) -> {
            int index = -1;
            if (ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                index = attribute.getIntContext(1) - 1;
            }
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            if (index < 0) {
                return null;
            }
            ListTag sub_list = new ListTag();
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split));
                if (strings.length > index) {
                    sub_list.add(strings[index]);
                    continue;
                }
                sub_list.add("null");
            }
            return sub_list;
        }, new String[0]);
        ListTag.registerTag("map_get", (attribute, object) -> {
            Deprecations.listOldMapTags.warn(attribute.context);
            if (object.isEmpty()) {
                return new ElementTag("");
            }
            ListTag input = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            ListTag result = new ListTag();
            for (String key : input) {
                for (String item : object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(key)) continue;
                    result.add(strings[1]);
                }
            }
            if (input.size() == 1 && result.size() == 1) {
                return new ElementTag(result.get(0));
            }
            if (input.size() > 1) {
                if (result.size() != input.size()) {
                    return null;
                }
                return result;
            }
            return null;
        }, new String[0]);
        ListTag.registerTag("map_find_key", (attribute, object) -> {
            Deprecations.listOldMapTags.warn(attribute.context);
            String input = attribute.getContext(1);
            String split = "/";
            if (attribute.startsWith("split_by", 2)) {
                if (attribute.hasContext(2) && attribute.getContext(2).length() > 0) {
                    split = attribute.getContext(2);
                }
                attribute.fulfill(1);
            }
            for (String item : object) {
                String[] strings = item.split(Pattern.quote(split), 2);
                if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                return new ElementTag(strings[0]);
            }
            return null;
        }, new String[0]);
        ListTag.registerTag("merge_maps", (attribute, object) -> {
            MapTag map = new MapTag();
            for (ObjectTag entry : object.objectForms) {
                MapTag subMap = MapTag.getMapFor(entry, attribute.context);
                if (subMap == null) {
                    attribute.echoError("Invalid map '" + entry + "' for merge_maps tag.");
                    return null;
                }
                map.map.putAll(subMap.map);
            }
            return map;
        }, new String[0]);
        ListTag.registerTag("to_map", (attribute, object) -> {
            String symbol = "/";
            if (attribute.hasContext(1)) {
                symbol = attribute.getContext(1);
            }
            MapTag map = new MapTag();
            for (String entry : object) {
                int slash = entry.indexOf(symbol);
                if (slash == -1) {
                    return null;
                }
                String key = entry.substring(0, slash);
                String value = entry.substring(slash + symbol.length());
                map.putObject(key, new ElementTag(value));
            }
            return map;
        }, new String[0]);
        ListTag.registerTag("map_with", (attribute, object) -> {
            ListTag inputList = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (object.size() != inputList.size()) {
                attribute.echoError("List.map_with tag failed: lists must be the same size!");
                return null;
            }
            MapTag map = new MapTag();
            for (int i = 0; i < object.size(); ++i) {
                map.putObject(object.get(i), inputList.getObject(i));
            }
            return map;
        }, new String[0]);
        ListTag.registerTag("size", (attribute, object) -> new ElementTag(object.size()), new String[0]);
        ListTag.registerTag("is_empty", (attribute, object) -> new ElementTag(object.isEmpty()), new String[0]);
        ListTag.registerTag("any", (attribute, object) -> new ElementTag(!object.isEmpty()), new String[0]);
        ListTag.registerTag("insert", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.insert[...] must have a value.");
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2));
                if (index < 0) {
                    index = 0;
                }
                if (index > result.size()) {
                    index = result.size();
                }
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.getObject(i));
                }
                attribute.fulfill(1);
                return result;
            }
            Debug.echoError("The tag ListTag.insert[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("set", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.set[...] must have a value.");
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2));
                if (index > result.size() - 1) {
                    index = result.size() - 1;
                }
                if (index < 0) {
                    index = 0;
                }
                attribute.fulfill(1);
                if (!result.isEmpty()) {
                    result.removeObject(index);
                }
                for (int i = 0; i < items.size(); ++i) {
                    result.addObject(index + i, items.objectForms.get(i));
                }
                return result;
            }
            Debug.echoError("The tag ListTag.set[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("set_single", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.set_single[...] must have a value.");
                return null;
            }
            ObjectTag value = attribute.getContextObject(1);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2));
                if (index > result.size() - 1) {
                    index = result.size() - 1;
                }
                if (index < 0) {
                    index = 0;
                }
                attribute.fulfill(1);
                if (!result.isEmpty()) {
                    result.removeObject(index);
                }
                result.addObject(index, value);
                return result;
            }
            Debug.echoError("The tag ListTag.set_single[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("overwrite", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.overwrite[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                return null;
            }
            ListTag items = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                ListTag result = new ListTag((ListTag)object);
                int index = object.parseIndex(attribute.getContext(2));
                if (index < 0) {
                    index = 0;
                }
                if (index > result.size() - 1) {
                    index = result.size() - 1;
                }
                attribute.fulfill(1);
                for (int i = 0; i < items.size(); ++i) {
                    if (index + i >= result.size()) {
                        result.addObject(items.objectForms.get(i));
                        continue;
                    }
                    result.setObject(index + i, items.objectForms.get(i));
                }
                return result;
            }
            Debug.echoError("The tag ListTag.overwrite[...] must be followed by .at[#]!");
            return null;
        }, new String[0]);
        ListTag.registerTag("include_single", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.include_single[...] must have a value.");
                return null;
            }
            ListTag copy = new ListTag((ListTag)object);
            copy.addObject(attribute.getContextObject(1));
            return copy;
        }, new String[0]);
        ListTag.registerTag("include", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.include[...] must have a value.");
                return null;
            }
            ListTag copy = new ListTag((ListTag)object);
            copy.addAll(ListTag.getListFor(attribute.getContextObject(1), attribute.context));
            return copy;
        }, new String[0]);
        ListTag.registerTag("exclude", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.exclude[...] must have a value.");
                return null;
            }
            ListTag exclusions = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag copy = new ListTag((ListTag)object);
            for (String exclusion : exclusions) {
                for (int i = 0; i < copy.size(); ++i) {
                    if (!CoreUtilities.equalsIgnoreCase(copy.get(i), exclusion)) continue;
                    copy.removeObject(i--);
                }
            }
            return copy;
        }, new String[0]);
        ListTag.registerTag("remove", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.remove[#] must have a value.");
                return null;
            }
            ListTag indices = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag copy = new ListTag((ListTag)object);
            if (indices.size() == 1 && attribute.startsWith("to", 2)) {
                if (!attribute.hasContext(2)) {
                    attribute.echoError("The tag ListTag.remove[#].to[#] must have a to value.");
                    return null;
                }
                int fromIndex = Math.max(0, object.parseIndex(indices.get(0)));
                int toIndex = Math.min(object.size() - 1, object.parseIndex(attribute.getContext(2)));
                attribute.fulfill(1);
                if (toIndex < fromIndex) {
                    return copy;
                }
                copy.objectForms.subList(fromIndex, toIndex + 1).clear();
                return copy;
            }
            for (String index : indices) {
                int remove = copy.parseIndex(index);
                if (remove < 0 || remove >= copy.size()) continue;
                copy.set(remove, "\u0000");
            }
            for (int i = 0; i < copy.size(); ++i) {
                if (!copy.get(i).equals("\u0000")) continue;
                copy.removeObject(i--);
            }
            return copy;
        }, new String[0]);
        ListTag.registerTag("shared_contents", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.shared_contents[...] must have a value.");
                return null;
            }
            ListTag secondList = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            ListTag output = new ListTag();
            for (String val : object) {
                if (!secondList.containsCaseInsensitive(val) || output.containsCaseInsensitive(val)) continue;
                output.add(val);
            }
            return output;
        }, new String[0]);
        ListTag.registerTag("replace", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.replace[...] must have a value.");
                return null;
            }
            String replace = attribute.getContext(1);
            ObjectTag replacement = null;
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                replacement = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag list = new ListTag();
            if (replace.startsWith("regex:")) {
                String regex = replace.substring("regex:".length());
                Pattern tempPat = Pattern.compile(regex);
                for (int i = 0; i < object.size(); ++i) {
                    if (tempPat.matcher(object.get(i)).matches()) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            } else {
                for (int i = 0; i < object.size(); ++i) {
                    if (CoreUtilities.equalsIgnoreCase(object.get(i), replace)) {
                        if (replacement == null) continue;
                        list.addObject(replacement);
                        continue;
                    }
                    list.addObject(object.getObject(i));
                }
            }
            return list;
        }, new String[0]);
        ListTag.registerTag("reverse", (attribute, object) -> {
            ArrayList<ObjectTag> objs = new ArrayList<ObjectTag>(object.objectForms);
            Collections.reverse(objs);
            return new ListTag((Collection<? extends ObjectTag>)objs);
        }, new String[0]);
        ListTag.registerTag("deduplicate", (attribute, object) -> object.deduplicate(), new String[0]);
        TagRunnable.ObjectInterface<ListTag> getRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.get[...] must have a value.");
                return null;
            }
            if (object.isEmpty()) {
                attribute.echoError("Can't get from an empty list.");
                return null;
            }
            ListTag indices = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            if (indices.size() > 1) {
                ListTag results = new ListTag();
                for (String index : indices) {
                    int ind = Integer.parseInt(index);
                    if (ind <= 0 || ind > object.size()) continue;
                    results.add(object.get(ind - 1));
                }
                return results;
            }
            if (indices.size() > 0) {
                int index = Integer.parseInt(indices.get(0)) - 1;
                if (index >= object.size()) {
                    attribute.echoError("Invalid list.get index '" + (index + 1) + "' ... list is only " + object.size() + " long.");
                    return null;
                }
                if (index < 0) {
                    attribute.echoError("Invalid list.get index '" + (index + 1) + "' ... must be at least 1.");
                    index = 0;
                }
                if (attribute.startsWith("to", 2) && attribute.hasContext(2)) {
                    int index2 = CoreUtilities.equalsIgnoreCase(attribute.getContext(2), "last") ? object.size() - 1 : attribute.getIntContext(2) - 1;
                    if (index2 >= object.size()) {
                        index2 = object.size() - 1;
                    }
                    if (index2 < 0) {
                        index2 = 0;
                    }
                    ListTag newList = new ListTag();
                    for (int i = index; i <= index2; ++i) {
                        newList.addObject(object.objectForms.get(i));
                    }
                    attribute.fulfill(1);
                    return newList;
                }
                return object.objectForms.get(index);
            }
            return null;
        };
        ListTag.registerTag("get", getRunnable, new String[0]);
        ListTag.registerTag("", getRunnable, new String[0]);
        ListTag.registerTag("find_all_partial", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.find_all_partial[...] must have a value.");
                return null;
            }
            String test = attribute.getContext(1).toUpperCase();
            ListTag positions = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                if (!object.get(i).toUpperCase().contains(test)) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        ListTag.registerTag("find_all", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.find_all[...] must have a value.");
                return null;
            }
            ListTag positions = new ListTag();
            for (int i = 0; i < object.size(); ++i) {
                if (!object.get(i).equalsIgnoreCase(attribute.getContext(1))) continue;
                positions.add(String.valueOf(i + 1));
            }
            return positions;
        }, new String[0]);
        ListTag.registerTag("find_partial", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.find_partial[...] must have a value.");
                return null;
            }
            String test = attribute.getContext(1).toUpperCase();
            for (int i = 0; i < object.size(); ++i) {
                if (!object.get(i).toUpperCase().contains(test)) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        ListTag.registerTag("find", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.find[...] must have a value.");
                return null;
            }
            for (int i = 0; i < object.size(); ++i) {
                if (!object.get(i).equalsIgnoreCase(attribute.getContext(1))) continue;
                return new ElementTag(i + 1);
            }
            return new ElementTag(-1);
        }, new String[0]);
        ListTag.registerTag("count", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.count[...] must have a value.");
                return null;
            }
            String element = attribute.getContext(1);
            int count = 0;
            for (int i = 0; i < object.size(); ++i) {
                if (!CoreUtilities.equalsIgnoreCase(object.get(i), element)) continue;
                ++count;
            }
            return new ElementTag(count);
        }, new String[0]);
        ListTag.registerTag("sum", (attribute, object) -> {
            BigDecimal sum = BigDecimal.ZERO;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum = sum.add(new ElementTag(entry).asBigDecimal());
            }
            return new ElementTag(sum);
        }, new String[0]);
        ListTag.registerTag("average", (attribute, object) -> {
            if (object.isEmpty()) {
                return new ElementTag(0);
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (String entry : object) {
                if (!ArgumentHelper.matchesDouble(entry)) continue;
                sum = sum.add(new ElementTag(entry).asBigDecimal());
            }
            try {
                return new ElementTag(sum.divide(new BigDecimal(object.size()), 64, RoundingMode.HALF_UP));
            }
            catch (Throwable e) {
                return new ElementTag(sum.doubleValue() / (double)object.size());
            }
        }, new String[0]);
        ListTag.registerTag("first", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(0);
        }, new String[0]);
        ListTag.registerTag("last", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            return object.objectForms.get(object.size() - 1);
        }, new String[0]);
        ListTag.registerTag("lowest", (attribute, object) -> {
            Attribute subAttribute;
            String tag = null;
            if (attribute.hasContext(1)) {
                tag = attribute.getRawContext(1);
            }
            try {
                subAttribute = tag == null ? null : new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            if (attribute.startsWith("count", 2) && attribute.hasContext(2)) {
                int count = Math.min(attribute.getIntContext(2), object.size());
                attribute.fulfill(1);
                int[] indices = new int[count];
                BigDecimal[] values = new BigDecimal[count];
                block2: for (int i = 0; i < object.size(); ++i) {
                    String str;
                    ObjectTag obj = object.getObject(i);
                    if (tag != null) {
                        obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    }
                    if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    for (int x = 0; x < count; ++x) {
                        if (values[x] != null && values[x].compareTo(val) <= 0) continue;
                        for (int j = count - 1; j > x; --j) {
                            values[j] = values[j - 1];
                            indices[j] = indices[j - 1];
                        }
                        values[x] = val;
                        indices[x] = i;
                        continue block2;
                    }
                }
                ListTag output = new ListTag(count);
                for (int i = 0; i < count; ++i) {
                    if (values[i] == null) continue;
                    output.addObject(object.getObject(indices[i]));
                }
                return output;
            }
            ObjectTag lowestObj = null;
            BigDecimal lowest = null;
            Iterator<ObjectTag> iterator = object.objectForms.iterator();
            while (iterator.hasNext()) {
                String str;
                ObjectTag obj;
                ObjectTag actualObj = obj = iterator.next();
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                }
                if (obj == null || !ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (lowest != null && lowest.compareTo(val) <= 0) continue;
                lowest = val;
                lowestObj = actualObj;
            }
            return lowestObj;
        }, new String[0]);
        ListTag.registerTag("highest", (attribute, object) -> {
            Attribute subAttribute;
            String tag = null;
            if (attribute.hasContext(1)) {
                tag = attribute.getRawContext(1);
            }
            try {
                subAttribute = tag == null ? null : new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            if (attribute.startsWith("count", 2) && attribute.hasContext(2)) {
                int count = Math.min(attribute.getIntContext(2), object.size());
                attribute.fulfill(1);
                int[] indices = new int[count];
                BigDecimal[] values = new BigDecimal[count];
                block2: for (int i = 0; i < object.size(); ++i) {
                    String str;
                    ObjectTag obj = object.getObject(i);
                    if (tag != null) {
                        obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    }
                    if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                    BigDecimal val = new ElementTag(str).asBigDecimal();
                    for (int x = 0; x < count; ++x) {
                        if (values[x] != null && values[x].compareTo(val) >= 0) continue;
                        for (int j = count - 1; j > x; --j) {
                            values[j] = values[j - 1];
                            indices[j] = indices[j - 1];
                        }
                        values[x] = val;
                        indices[x] = i;
                        continue block2;
                    }
                }
                ListTag output = new ListTag(count);
                for (int i = 0; i < count; ++i) {
                    if (values[i] == null) continue;
                    output.addObject(object.getObject(indices[i]));
                }
                return output;
            }
            ObjectTag highestObj = null;
            BigDecimal highest = null;
            Iterator<ObjectTag> iterator = object.objectForms.iterator();
            while (iterator.hasNext()) {
                String str;
                ObjectTag obj;
                ObjectTag actualObj = obj = iterator.next();
                if (tag != null) {
                    obj = CoreUtilities.autoAttribTyped(obj, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                }
                if (!ArgumentHelper.matchesDouble(str = obj.toString())) continue;
                BigDecimal val = new ElementTag(str).asBigDecimal();
                if (highest != null && highest.compareTo(val) >= 0) continue;
                highest = val;
                highestObj = actualObj;
            }
            return highestObj;
        }, new String[0]);
        ListTag.registerTag("numerical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort((o1, o2) -> {
                double value = new ElementTag((String)o1).asDouble() - new ElementTag((String)o2).asDouble();
                if (value == 0.0) {
                    return 0;
                }
                if (value > 0.0) {
                    return 1;
                }
                return -1;
            });
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("alphanumeric", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort(new NaturalOrderComparator());
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("alphabetical", (attribute, object) -> {
            ArrayList<String> sortable = new ArrayList<String>((Collection<String>)((Object)object));
            sortable.sort(String::compareToIgnoreCase);
            return new ListTag((List<String>)sortable);
        }, new String[0]);
        ListTag.registerTag("sort_by_value", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag list.sort_by_value[...] must have input!");
                return null;
            }
            ListTag newlist = new ListTag((ListTag)object);
            NaturalOrderComparator comparator = new NaturalOrderComparator();
            String tag = attribute.getRawContext(1);
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                newlist.objectForms.sort((o1, o2) -> {
                    ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    return comparator.compare(or1, or2);
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        ListTag.registerTag("sort_by_number", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasContext(1)) {
                attribute.echoError("Sort_By_Number[...] must have an input value.");
                return null;
            }
            ListTag newlist = new ListTag((ListTag)object);
            String tag = attribute.getRawContext(1);
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                newlist.objectForms.sort((o1, o2) -> {
                    ObjectTag or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    ObjectTag or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context));
                    try {
                        double r1 = Double.parseDouble(or1.toString());
                        double r2 = Double.parseDouble(or2.toString());
                        double value = r1 - r2;
                        if (value == 0.0) {
                            return 0;
                        }
                        if (value > 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (NumberFormatException ex) {
                        attribute.echoError("Invalid non-numerical input to sort_by_number tag: " + or1.toString() + ", " + or2.toString());
                        return 0;
                    }
                });
                return new ListTag((Collection<? extends ObjectTag>)newlist.objectForms);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
                return newlist;
            }
        }, new String[0]);
        ListTag.registerTag("sort", (attribute, object) -> {
            ListTag obj = new ListTag((ListTag)object);
            ProcedureScriptContainer script = (ProcedureScriptContainer)attribute.contextAsType(1, ScriptTag.class).getContainer();
            if (script == null) {
                attribute.echoError("'" + attribute.getContext(1) + "' is not a valid procedure script!");
                return obj;
            }
            ScriptEntry entry = attribute.getScriptEntry();
            ListTag context = new ListTag();
            if (attribute.startsWith("context", 2)) {
                context = ListTag.getListFor(attribute.getContextObject(2), attribute.context);
                attribute.fulfill(1);
            }
            ListTag context_send = context;
            ArrayList<String> list = new ArrayList<String>(obj);
            try {
                list.sort((o1, o2) -> {
                    List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.getImplementation().getEmptyScriptEntryData() : entry.entryData.clone());
                    if (entries.isEmpty()) {
                        return 0;
                    }
                    InstantQueue queue = new InstantQueue("LISTTAG_SORT");
                    queue.addEntries(entries);
                    int x = 1;
                    ListTag definitions = new ListTag();
                    definitions.add((String)o1);
                    definitions.add((String)o2);
                    definitions.addAll(context_send);
                    String[] definition_names = null;
                    try {
                        definition_names = script.getString("definitions").split("\\|");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (String definition : definitions) {
                        String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                        queue.addDefinition(name, definition);
                        Debug.echoDebug((Debuggable)entries.get(0), "Adding definition '" + name + "' as " + definition);
                        ++x;
                    }
                    queue.start();
                    int res = 0;
                    if (queue.determinations != null && queue.determinations.size() > 0) {
                        res = new ElementTag(queue.determinations.get(0)).asInt();
                    }
                    return Integer.compare(res, 0);
                });
            }
            catch (Exception e) {
                Debug.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
            }
            return new ListTag((List<String>)list);
        }, new String[0]);
        ListTag.registerTag("filter", (attribute, object) -> {
            Attribute subAttribute;
            String tag = attribute.getRawContext(1);
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            ListTag newlist = new ListTag();
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(true);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (!(objs == null ? defaultValue : CoreUtilities.equalsIgnoreCase(objs.toString(), "true"))) continue;
                    newlist.addObject(obj);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("parse", (attribute, object) -> {
            Attribute subAttribute;
            ListTag newlist = new ListTag();
            String tag = attribute.getRawContext(1);
            String defaultValue = "null";
            boolean fallback = false;
            if (tag.contains("||")) {
                int marks = 0;
                int lengthLimit = tag.length() - 1;
                for (int i = 0; i < lengthLimit; ++i) {
                    char c = tag.charAt(i);
                    if (c == '<') {
                        ++marks;
                        continue;
                    }
                    if (c == '>') {
                        --marks;
                        continue;
                    }
                    if (marks != 0 || c != '|' || tag.charAt(i + 1) != '|') continue;
                    fallback = true;
                    defaultValue = tag.substring(i + 2);
                    tag = tag.substring(0, i);
                    break;
                }
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            try {
                for (ObjectTag obj : object.objectForms) {
                    Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
                    tempAttrib.setHadAlternative(attribute.hasAlternative() || fallback);
                    ObjectTag objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                    if (objs == null) {
                        objs = new ElementTag(defaultValue);
                    }
                    newlist.addObject(objs);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("filter_tag", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("Must have input to filter_tag[...]");
                return null;
            }
            ListTag newlist = new ListTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (ObjectTag obj : object.objectForms) {
                    provider.altDefs.putObject("filter_value", obj);
                    if (!CoreUtilities.equalsIgnoreCase(attribute.parseDynamicContext(1, provider).toString(), "true")) continue;
                    newlist.addObject(obj);
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("parse_tag", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("Must have input to parse_tag[...]");
                return null;
            }
            ListTag newlist = new ListTag();
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            try {
                for (ObjectTag obj : object.objectForms) {
                    provider.altDefs.putObject("parse_value", obj);
                    newlist.addObject(attribute.parseDynamicContext(1, provider));
                }
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return newlist;
        }, new String[0]);
        ListTag.registerTag("pad_left", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.pad_left[...] must have a value.");
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(0, with);
            }
            return newList;
        }, new String[0]);
        ListTag.registerTag("pad_right", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.pad_right[...] must have a value.");
                return null;
            }
            ObjectTag with = new ElementTag("");
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = attribute.getContextObject(2);
                attribute.fulfill(1);
            }
            ListTag newList = new ListTag((ListTag)object);
            while (newList.size() < length) {
                newList.addObject(with);
            }
            return newList;
        }, new String[0]);
        ListTag.registerTag("escape_contents", (attribute, object) -> {
            Deprecations.listEscapeContents.warn(attribute.context);
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.escape(entry));
            }
            return escaped;
        }, new String[0]);
        ListTag.registerTag("unescape_contents", (attribute, object) -> {
            Deprecations.listEscapeContents.warn(attribute.context);
            ListTag escaped = new ListTag();
            for (String entry : object) {
                escaped.add(EscapeTagBase.unEscape(entry));
            }
            return escaped;
        }, new String[0]);
        ListTag.registerTag("contains_any_case_sensitive", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.contains_any_case_sensitive[...] must have a value.");
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!element.equals(sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains_any", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.contains_any[...] must have a value.");
                return null;
            }
            ListTag list = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            boolean state = false;
            block0: for (String element : object) {
                for (String sub_element : list) {
                    if (!CoreUtilities.equalsIgnoreCase(element, sub_element)) continue;
                    state = true;
                    break block0;
                }
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains_case_sensitive", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.contains_case_sensitive[...] must have a value.");
                return null;
            }
            boolean state = false;
            for (String element : object) {
                if (!element.equals(attribute.getContext(1))) continue;
                state = true;
                break;
            }
            return new ElementTag(state);
        }, new String[0]);
        ListTag.registerTag("contains", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ListTag.contains[...] must have a value.");
                return null;
            }
            ListTag needed = ListTag.getListFor(attribute.getContextObject(1), attribute.context);
            int gotten = 0;
            block0: for (String check : needed) {
                for (String element : object) {
                    if (!CoreUtilities.equalsIgnoreCase(element, check)) continue;
                    ++gotten;
                    continue block0;
                }
            }
            return new ElementTag(gotten == needed.size() && gotten > 0);
        }, new String[0]);
        ListTag.registerTag("random", (attribute, object) -> {
            if (object.isEmpty()) {
                return null;
            }
            if (attribute.hasContext(1)) {
                int count = Integer.valueOf(attribute.getContext(1));
                ArrayList<ObjectTag> available = new ArrayList<ObjectTag>(object.objectForms);
                ListTag toReturn = new ListTag();
                for (int times = 0; !available.isEmpty() && times < count; ++times) {
                    int random = CoreUtilities.getRandom().nextInt(available.size());
                    toReturn.addObject(available.get(random));
                    available.remove(random);
                }
                return toReturn;
            }
            return object.objectForms.get(CoreUtilities.getRandom().nextInt(object.size()));
        }, new String[0]);
        ListTag.registerTag("closest_to", (attribute, object) -> new ElementTag(CoreUtilities.getClosestOption(object, attribute.getContext(1))), new String[0]);
        ListTag.registerTag("as_list", (attribute, object) -> new ListTag((ListTag)object), "aslist");
    }

    public boolean containsCaseInsensitive(String val) {
        val = CoreUtilities.toLowerCase(val);
        for (String str : this) {
            if (!CoreUtilities.toLowerCase(str).equals(val)) continue;
            return true;
        }
        return false;
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ListTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag specialTagProcessing(Attribute attribute) {
        int index;
        String attrLow = attribute.getAttributeWithoutContext(1);
        if (Debug.verbose) {
            Debug.log("ListTag alternate attribute " + attrLow);
        }
        if (ArgumentHelper.matchesInteger(attrLow) && (index = Integer.parseInt(attrLow)) != 0) {
            attribute.fulfill(1);
            if (index < 1 || index > this.size()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("ListTag index " + index + " is out of range");
                }
                return null;
            }
            return this.getObject(index - 1);
        }
        return null;
    }

    public static class ListTagStringIterator
    implements ListIterator<String> {
        public ListTag list;
        int index;

        public ListTagStringIterator(ListTag list, int index) {
            this.list = list;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public String next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public String previous() {
            return this.list.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.list.remove(this.index--);
        }

        @Override
        public void set(String s) {
            this.list.set(this.index, s);
        }

        @Override
        public void add(String s) {
            this.list.add(this.index++, s);
        }
    }
}

