/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues;

import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.CommandExecutor;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class ScriptEngine {
    public final CommandExecutor commandExecutor = new CommandExecutor();

    boolean shouldHold(ScriptQueue scriptQueue) {
        if (scriptQueue instanceof TimedQueue && ((TimedQueue)scriptQueue).isPaused()) {
            return true;
        }
        if (scriptQueue.getLastEntryExecuted() == null || !scriptQueue.getLastEntryExecuted().shouldWaitFor()) {
            return false;
        }
        if (!(scriptQueue instanceof TimedQueue)) {
            Debug.echoDebug((Debuggable)scriptQueue.getLastEntryExecuted(), "Forcing queue " + scriptQueue.id + " into a timed queue...");
            scriptQueue.forceToTimed(null);
        }
        return true;
    }

    public void revolveOnceForce(ScriptQueue scriptQueue) {
        ScriptEntry scriptEntry = scriptQueue.getNext();
        if (scriptEntry == null) {
            return;
        }
        scriptEntry.setSendingQueue(scriptQueue);
        scriptEntry.updateContext();
        scriptQueue.setLastEntryExecuted(scriptEntry);
        try {
            this.commandExecutor.execute(scriptEntry);
        }
        catch (Throwable e) {
            Debug.echoError(scriptEntry, "An exception has been called with this command (while revolving the queue forcefully)!");
            Debug.echoError(scriptEntry.getResidingQueue(), e);
        }
    }

    public void revolve(ScriptQueue scriptQueue) {
        if (this.shouldHold(scriptQueue)) {
            return;
        }
        ScriptEntry scriptEntry = scriptQueue.getNext();
        while (scriptEntry != null) {
            scriptEntry.setSendingQueue(scriptQueue);
            scriptEntry.updateContext();
            scriptQueue.setLastEntryExecuted(scriptEntry);
            this.commandExecutor.execute(scriptEntry);
            if (scriptQueue instanceof TimedQueue) {
                TimedQueue delayedQueue = (TimedQueue)scriptQueue;
                if (delayedQueue.isDelayed() || delayedQueue.isPaused() || !delayedQueue.isInstantSpeed() && !scriptEntry.isInstant()) break;
                if (this.shouldHold(scriptQueue)) {
                    return;
                }
                scriptEntry = scriptQueue.getNext();
                continue;
            }
            if (!scriptEntry.isInstant()) break;
            if (this.shouldHold(scriptQueue)) {
                return;
            }
            scriptEntry = scriptQueue.getNext();
        }
    }
}

