/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.AnimationHelper;
import net.aufdemrand.denizen.nms.interfaces.EntityAnimation;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Player;

public class AnimateCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        AnimationHelper animationHelper = NMSHandler.getInstance().getAnimationHelper();
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
            }
            if (scriptEntry.hasObject("animation") || scriptEntry.hasObject("effect") || scriptEntry.hasObject("nms_animation")) continue;
            if (arg.matchesEnum((Enum<?>[])PlayerAnimation.values())) {
                scriptEntry.addObject("animation", PlayerAnimation.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesEnum((Enum<?>[])EntityEffect.values())) {
                scriptEntry.addObject("effect", EntityEffect.valueOf((String)arg.getValue().toUpperCase()));
                continue;
            }
            if (!animationHelper.hasEntityAnimation(arg.getValue())) continue;
            scriptEntry.addObject("nms_animation", arg.getValue());
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("animation") || scriptEntry.hasObject("nms_animation"))) {
            throw new InvalidArgumentsException("Must specify a valid animation!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String nmsAnimation;
        List entities = (List)scriptEntry.getObject("entities");
        PlayerAnimation animation = scriptEntry.hasObject("animation") ? (PlayerAnimation)scriptEntry.getObject("animation") : null;
        EntityEffect effect = scriptEntry.hasObject("effect") ? (EntityEffect)scriptEntry.getObject("effect") : null;
        String string = nmsAnimation = scriptEntry.hasObject("nms_animation") ? (String)scriptEntry.getObject("nms_animation") : null;
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (animation != null ? aH.debugObj("animation", animation.name()) : (effect != null ? aH.debugObj("effect", effect.name()) : aH.debugObj("animation", nmsAnimation))) + aH.debugObj("entities", entities.toString()));
        }
        for (dEntity entity : entities) {
            if (!entity.isSpawned()) continue;
            try {
                if (animation != null && entity.getBukkitEntity() instanceof Player) {
                    Player player = (Player)entity.getBukkitEntity();
                    animation.play(player);
                    continue;
                }
                if (effect != null) {
                    entity.getBukkitEntity().playEffect(effect);
                    continue;
                }
                EntityAnimation entityAnimation = NMSHandler.getInstance().getAnimationHelper().getEntityAnimation(nmsAnimation);
                entityAnimation.play(entity.getBukkitEntity());
            }
            catch (Exception e) {
                dB.echoError(scriptEntry.getResidingQueue(), "Error playing that animation!");
            }
        }
    }
}

