/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.queue.IfCommand;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import java.util.ArrayList;
import java.util.List;

public class WaitUntilCommand
extends AbstractCommand
implements Holdable {
    public WaitUntilCommand() {
        this.setName("waituntil");
        this.setSyntax("waituntil (rate:<duration>) (max:<duration>) [<comparisons>]");
        this.setRequiredArguments(1, -1);
        this.setParseArgs(false);
        this.forceHold = true;
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<String> arguments = new ArrayList<String>(scriptEntry.getArguments());
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("rate") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("rate", arg.asType(DurationTag.class));
                arguments.remove(0);
                continue;
            }
            if (!arg.matchesPrefix("max") || !arg.matchesArgumentType(DurationTag.class)) break;
            scriptEntry.addObject("max", arg.asType(DurationTag.class));
            arguments.remove(0);
        }
        scriptEntry.addObject("comparisons", arguments);
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final List comparisons = (List)scriptEntry.getObject("comparisons");
        DurationTag rate = (DurationTag)scriptEntry.getObjectTag("rate");
        DurationTag max = (DurationTag)scriptEntry.getObjectTag("max");
        boolean run = new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("run_first_check", run), rate, max);
        }
        if (run) {
            scriptEntry.setFinished(true);
            return;
        }
        if (rate == null) {
            rate = scriptEntry.getResidingQueue() instanceof TimedQueue ? ((TimedQueue)scriptEntry.getResidingQueue()).getSpeed() : new DurationTag(1L);
        }
        final long endTime = max == null ? -1L : DenizenCore.serverTimeMillis + max.getMillis();
        final RepeatingSchedulable schedulable = new RepeatingSchedulable(null, (float)rate.getSeconds());
        schedulable.run = new Runnable(){
            public int counter = 0;

            @Override
            public void run() {
                ++this.counter;
                if (new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry)) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil completed after " + this.counter + " re-checks.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                } else if (endTime != -1L && endTime < DenizenCore.serverTimeMillis) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil completed due to time out.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                }
            }
        };
        DenizenCore.schedule(schedulable);
    }
}

