/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class DurationTag
implements ObjectTag {
    @Deprecated
    public static final DurationTag ZERO = new DurationTag(0);
    private double seconds;
    private String prefix = "Duration";
    public static ObjectTagProcessor<DurationTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static DurationTag valueOf(String string) {
        return DurationTag.valueOf(string, null);
    }

    @Fetchable(value="d")
    public static DurationTag valueOf(String string, TagContext context) {
        String[] split;
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("d@")) {
            string = string.substring("d@".length());
        }
        if (string.equals("instant") || string.equals("infinite")) {
            return new DurationTag(0);
        }
        if (string.isEmpty()) {
            return null;
        }
        if (string.contains("-") && !string.startsWith("-") && !string.contains("e-") && (split = string.split("-", 2)).length == 2) {
            DurationTag low = DurationTag.valueOf(split[0], context);
            DurationTag high = DurationTag.valueOf(split[1], context);
            if (low != null && high != null) {
                if (high.getSecondsAsInt() < low.getSecondsAsInt()) {
                    DurationTag temp = low;
                    low = high;
                    high = temp;
                }
                int seconds = CoreUtilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1) + low.getSecondsAsInt();
                if (Debug.verbose) {
                    Debug.log("Getting random duration between " + low.identify() + " and " + high.identify() + "... " + seconds + "s");
                }
                return new DurationTag(seconds);
            }
            return null;
        }
        String numericString = Character.isDigit(string.charAt(string.length() - 1)) ? string : string.substring(0, string.length() - 1);
        try {
            double numVal = Double.valueOf(numericString);
            if (string.endsWith("y")) {
                return new DurationTag(numVal * 3.1536E7);
            }
            if (string.endsWith("w")) {
                return new DurationTag(numVal * 604800.0);
            }
            if (string.endsWith("d")) {
                return new DurationTag(numVal * 86400.0);
            }
            if (string.endsWith("h")) {
                return new DurationTag(numVal * 3600.0);
            }
            if (string.endsWith("m")) {
                return new DurationTag(numVal * 60.0);
            }
            if (string.endsWith("s")) {
                return new DurationTag(numVal);
            }
            if (string.endsWith("t")) {
                return new DurationTag(numVal * 0.05);
            }
            if (numericString.equals(string)) {
                return new DurationTag(Double.valueOf(numericString));
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("Duration type '" + string + "' is not valid.");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        try {
            return DurationTag.valueOf(string, CoreUtilities.noDebugContext) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public DurationTag(double seconds) {
        this.seconds = seconds;
    }

    public DurationTag(int seconds) {
        this.seconds = seconds;
    }

    public DurationTag(long ticks) {
        this.seconds = (double)ticks / 20.0;
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return (int)(this.seconds * 20.0);
    }

    public long getMillis() {
        double millis = this.seconds * 1000.0;
        return (long)millis;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        return "d@" + this.seconds + "s <GR>(" + this.formatted(false) + ")";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "duration";
    }

    @Override
    public String identify() {
        return "d@" + this.seconds + "s";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        tagProcessor.registerTag(ElementTag.class, "in_years", (attribute, object) -> new ElementTag(object.seconds / 3.1536E7), "years");
        tagProcessor.registerTag(ElementTag.class, "in_weeks", (attribute, object) -> new ElementTag(object.seconds / 604800.0), "weeks");
        tagProcessor.registerTag(ElementTag.class, "in_days", (attribute, object) -> new ElementTag(object.seconds / 86400.0), "days");
        tagProcessor.registerTag(ElementTag.class, "in_hours", (attribute, object) -> new ElementTag(object.seconds / 3600.0), "hours");
        tagProcessor.registerTag(ElementTag.class, "in_minutes", (attribute, object) -> new ElementTag(object.seconds / 60.0), "minutes");
        tagProcessor.registerTag(ElementTag.class, "in_seconds", (attribute, object) -> new ElementTag(object.seconds), "seconds");
        tagProcessor.registerTag(ElementTag.class, "in_milliseconds", (attribute, object) -> new ElementTag(object.seconds * 1000.0), "milliseconds");
        tagProcessor.registerTag(ElementTag.class, "in_ticks", (attribute, object) -> new ElementTag((long)(object.seconds * 20.0)), "ticks");
        tagProcessor.registerTag(DurationTag.class, "sub", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag DurationTag.sub[...] must have a value.");
                return null;
            }
            return new DurationTag(object.getTicks() - attribute.contextAsType(1, DurationTag.class).getTicks());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag DurationTag.add[...] must have a value.");
                return null;
            }
            return new DurationTag(object.getTicks() + attribute.contextAsType(1, DurationTag.class).getTicks());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_more_than", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.seconds > attribute.contextAsType((int)1, DurationTag.class).seconds);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_less_than", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.seconds < attribute.contextAsType((int)1, DurationTag.class).seconds);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_more_than_or_equal_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.seconds >= attribute.contextAsType((int)1, DurationTag.class).seconds);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_less_than_or_equal_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.seconds <= attribute.contextAsType((int)1, DurationTag.class).seconds);
        }, new String[0]);
        tagProcessor.registerTag(TimeTag.class, "time", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return new TimeTag(object.getMillis());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "formatted", (attribute, object) -> new ElementTag(object.formatted(false)), "value");
        tagProcessor.registerTag(ElementTag.class, "formatted_words", (attribute, object) -> new ElementTag(object.formatted(true)), new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    private static String autoS(long val) {
        return val == 1L ? " " : "s ";
    }

    public String formatted(boolean words) {
        boolean isNegative;
        double secondsCopy = this.seconds;
        boolean bl = isNegative = secondsCopy < 0.0;
        if (isNegative) {
            secondsCopy *= -1.0;
        }
        long seconds = (long)secondsCopy;
        long yearsRaw = seconds / 31536000L;
        long daysRaw = seconds / 86400L;
        long hoursRaw = seconds / 3600L;
        long minutesRaw = seconds / 60L;
        long years = yearsRaw;
        long days = daysRaw - years * 365L;
        long hours = hoursRaw - daysRaw * 24L;
        long minutes = minutesRaw - hours * 60L;
        seconds -= minutesRaw * 60L;
        String timeString = "";
        if (years > 0L) {
            timeString = years + (words ? " year" + DurationTag.autoS(years) : "y ");
        }
        if (days > 0L) {
            timeString = timeString + days + (words ? " day" + DurationTag.autoS(days) : "d ");
        }
        if (hours > 0L && years == 0L) {
            timeString = timeString + hours + (words ? " hour" + DurationTag.autoS(hours) : "h ");
        }
        if (minutes > 0L && days == 0L && years == 0L) {
            timeString = timeString + minutes + (words ? " minute" + DurationTag.autoS(minutes) : "m ");
        }
        if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L && years == 0L) {
            timeString = timeString + seconds + (words ? " second" + DurationTag.autoS(seconds) : "s ");
        }
        if (timeString.isEmpty()) {
            timeString = secondsCopy == 0.0 ? "forever" : (double)((long)(secondsCopy * 100.0)) / 100.0 + "s";
        }
        return (isNegative ? "negative " : "") + timeString.trim();
    }
}

