/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;

public class StatisticCommand
extends AbstractCommand {
    public StatisticCommand() {
        this.setName("statistic");
        this.setSyntax("statistic [<statistic>] [add/take/set] (<#>) (qualifier:<material>/<entity>)");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Statistic stat : Statistic.values()) {
            addOne.accept(stat.name());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Statistic.Type type;
        boolean specified_players = false;
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("players") && !scriptEntry.hasObject("players") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class));
                specified_players = true;
                continue;
            }
            if (!scriptEntry.hasObject("statistic") && arg.matchesEnum((Enum<?>[])Statistic.values())) {
                scriptEntry.addObject("statistic", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("amount") && arg.matchesInteger()) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!arg.matchesPrefix("qualifier", "q") || scriptEntry.hasObject("material") || scriptEntry.hasObject("entity")) continue;
            if (arg.matchesArgumentType(MaterialTag.class)) {
                scriptEntry.addObject("material", arg.asType(MaterialTag.class));
                continue;
            }
            if (!arg.matchesArgumentType(EntityTag.class)) continue;
            scriptEntry.addObject("entity", arg.asType(EntityTag.class));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
        if (!scriptEntry.hasObject("statistic")) {
            throw new InvalidArgumentsException("Must specify a valid Statistic!");
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new ElementTag(1));
        }
        if ((type = Statistic.valueOf((String)scriptEntry.getElement("statistic").asString().toUpperCase()).getType()) != Statistic.Type.UNTYPED) {
            if (!(type != Statistic.Type.BLOCK && type != Statistic.Type.ITEM || scriptEntry.hasObject("material"))) {
                throw new InvalidArgumentsException("Must specify a valid " + type.name() + " MATERIAL!");
            }
            if (type == Statistic.Type.ENTITY && !scriptEntry.hasObject("entity")) {
                throw new InvalidArgumentsException("Must specify a valid ENTITY!");
            }
        }
        if (!scriptEntry.hasObject("players") && Utilities.entryHasPlayer(scriptEntry) && !specified_players) {
            scriptEntry.addObject("players", new ListTag(Utilities.getEntryPlayer(scriptEntry)));
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must specify valid players!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block30: {
            ElementTag action = scriptEntry.getElement("action");
            ListTag players = (ListTag)scriptEntry.getObjectTag("players");
            ElementTag statistic = scriptEntry.getElement("statistic");
            ElementTag amount = scriptEntry.getElement("amount");
            MaterialTag material = (MaterialTag)scriptEntry.getObjectTag("material");
            EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), action.debug() + statistic.debug() + amount.debug() + players.debug() + (material != null ? material.debug() : (entity != null ? entity.debug() : "")));
            }
            Action act = Action.valueOf(action.asString().toUpperCase());
            Statistic stat = Statistic.valueOf((String)statistic.asString().toUpperCase());
            int amt = amount.asInt();
            block0 : switch (stat.getType()) {
                case BLOCK: 
                case ITEM: {
                    Material mat = material.getMaterial();
                    switch (act) {
                        case ADD: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.incrementStatistic(stat, mat, amt);
                            }
                            break block0;
                        }
                        case TAKE: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.decrementStatistic(stat, mat, amt);
                            }
                            break block0;
                        }
                        case SET: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.setStatistic(stat, mat, amt);
                            }
                        }
                    }
                    break;
                }
                case ENTITY: {
                    EntityType ent = entity.getBukkitEntityType();
                    switch (act) {
                        case ADD: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.incrementStatistic(stat, ent, amt);
                            }
                            break block0;
                        }
                        case TAKE: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.decrementStatistic(stat, ent, amt);
                            }
                            break block0;
                        }
                        case SET: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.setStatistic(stat, ent, amt);
                            }
                        }
                    }
                    break;
                }
                case UNTYPED: {
                    switch (act) {
                        case ADD: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.incrementStatistic(stat, amt);
                            }
                            break block30;
                        }
                        case TAKE: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.decrementStatistic(stat, amt);
                            }
                            break block30;
                        }
                        case SET: {
                            for (PlayerTag player : players.filter(PlayerTag.class, scriptEntry)) {
                                player.setStatistic(stat, amt);
                            }
                        }
                    }
                }
            }
        }
    }

    private static enum Action {
        ADD,
        TAKE,
        SET;

    }
}

