/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;

public class CoreUtilities {
    public static TagContext noDebugContext;
    public static TagContext basicContext;
    public static TagContext errorButNoDebugContext;
    public static DecimalFormatSymbols decimalFormatSymbols;
    public static final char NBSP_Char = '\u00a0';
    public static final String NBSP;
    public static List<Function<Object, ObjectTag>> objectConversions;
    public static Map<Class<? extends ObjectTag>, TypeComparisonRunnable> typeCheckers;
    public static Map<Class<? extends ObjectTag>, TagTypeConverter> typeConverters;
    static Random random;
    static FilenameFilter scriptsFilter;
    public static DecimalFormat df;
    public static DecimalFormat floatFormat;
    private static byte[] valueOfHex;
    public static char[] charForByte;

    public static String clearNBSPs(String input) {
        return input.replace('\u00a0', ' ');
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context) {
        return CoreUtilities.objectToTagForm(obj, context, false);
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context, boolean scriptStrip) {
        return CoreUtilities.objectToTagForm(obj, context, scriptStrip, false);
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context, boolean scriptStrip, boolean doParse) {
        return CoreUtilities.objectToTagForm(obj, context, scriptStrip, doParse, true);
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context, boolean scriptStrip, boolean doParse, boolean canPick) {
        if (obj == null) {
            return new ElementTag("null");
        }
        if (obj instanceof YamlConfiguration) {
            obj = ((YamlConfiguration)((Object)obj)).contents;
        }
        if (obj instanceof ObjectTag) {
            return (ObjectTag)((Object)obj);
        }
        if (obj instanceof Map) {
            MapTag result = new MapTag();
            for (Map.Entry<StringHolder, Object> entry : obj.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (scriptStrip) {
                    key = ScriptBuilder.stripLinePrefix(key);
                }
                result.putObject(key, CoreUtilities.objectToTagForm(entry.getValue(), context, scriptStrip, doParse, canPick));
            }
            return result;
        }
        if (obj instanceof Iterable) {
            ListTag listResult = new ListTag();
            for (Object subObj : (Iterable)((Object)obj)) {
                listResult.addObject(CoreUtilities.objectToTagForm(subObj, context, scriptStrip, doParse, canPick));
            }
            return listResult;
        }
        for (Function<Object, ObjectTag> func : objectConversions) {
            ObjectTag result = func.apply(obj);
            if (result == null) continue;
            return result.duplicate();
        }
        String result = obj.toString();
        if (scriptStrip) {
            result = ScriptBuilder.stripLinePrefix(result);
        }
        if (doParse) {
            return TagManager.tagObject(result, context);
        }
        if (canPick) {
            return ObjectFetcher.pickObjectFor(result, context);
        }
        return new ElementTag(result, true);
    }

    public static Object objectTagToJavaForm(ObjectTag obj, boolean stringHolder) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ListTag) {
            ArrayList<Object> output = new ArrayList<Object>(((ListTag)obj).size());
            for (ObjectTag entry : ((ListTag)obj).objectForms) {
                output.add(CoreUtilities.objectTagToJavaForm(entry, stringHolder));
            }
            return output;
        }
        if (obj instanceof MapTag) {
            LinkedHashMap<Object, Object> output = new LinkedHashMap<Object, Object>();
            for (Map.Entry<StringHolder, ObjectTag> entry : ((MapTag)obj).map.entrySet()) {
                output.put(stringHolder ? entry.getKey() : entry.getKey().str, CoreUtilities.objectTagToJavaForm(entry.getValue(), stringHolder));
            }
            return output;
        }
        return obj.toString();
    }

    public static String splitLinesByCharacterCount(String str, int length) {
        if (length < 3) {
            return str;
        }
        StringBuilder output = new StringBuilder(str.length() * 2);
        int curLineLen = 0;
        int lineStart = 0;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                output.append(str, lineStart, i + 1);
                curLineLen = 0;
                lineStart = i + 1;
                continue;
            }
            if (++curLineLen <= length) continue;
            for (int x = i - 1; x > lineStart; --x) {
                char xc = str.charAt(x);
                if (xc != ' ') continue;
                output.append(str, lineStart, x).append("\n");
                curLineLen = 0;
                lineStart = x + 1;
                i = x;
                continue block0;
            }
            output.append(str, lineStart, i).append("\n");
            curLineLen = 0;
            lineStart = i;
        }
        output.append(str, lineStart, str.length());
        return output.toString();
    }

    public static void fixNewLinesToListSeparation(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String line = list.get(i);
            if (!line.contains("\n")) continue;
            List<String> split = CoreUtilities.split(line, '\n');
            list.set(i, split.get(0));
            for (int x = 1; x < split.size(); ++x) {
                list.add(i + x, split.get(x));
            }
        }
    }

    public static String replace(String original, String findMe, String swapMeIn) {
        int firstIndex = original.indexOf(findMe);
        if (firstIndex < 0) {
            return original;
        }
        int lastIndex = original.lastIndexOf(findMe);
        if (firstIndex == lastIndex) {
            return original.substring(0, firstIndex) + swapMeIn + original.substring(lastIndex + findMe.length());
        }
        StringBuilder output = new StringBuilder(original.length() * 2);
        int prevIndex = 0;
        while (firstIndex != -1) {
            output.append(original, prevIndex, firstIndex).append(swapMeIn);
            prevIndex = firstIndex + findMe.length();
            firstIndex = original.indexOf(findMe, prevIndex);
        }
        output.append(original, prevIndex, original.length());
        return output.toString();
    }

    public static String join(String delim, List objects) {
        StringBuilder output = new StringBuilder(objects.size() * 5);
        for (int i = 0; i < objects.size(); ++i) {
            output.append(objects.get(i));
            if (i + 1 >= objects.size()) continue;
            output.append(delim);
        }
        return output.toString();
    }

    public static String stringifyNullPass(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static ObjectTag fixType(ObjectTag input, TagContext context) {
        if (input instanceof ElementTag && !((ElementTag)input).isPlainText) {
            return ObjectFetcher.pickObjectFor(input.toString(), context);
        }
        return input;
    }

    public static void autoPropertyMechanism(ObjectTag object, Mechanism mechanism) {
        if (mechanism.fulfilled()) {
            return;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return;
        }
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByMechanism.get(mechanism.getName());
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                mechanism.echoError("Cannot apply property mechanism - object does not fit property requirements?");
                return;
            }
            prop.adjust(mechanism);
            return;
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyMechs) {
            Property prop = listGetter.get(object);
            if (prop == null) continue;
            prop.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            return;
        }
    }

    public static ObjectTag autoPropertyTagObject(ObjectTag object, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return null;
        }
        String tagName = attribute.getAttributeWithoutContext(1);
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByTag.get(tagName);
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                String propName = properties.propertyNamesByTag.get(tagName);
                attribute.seemingSuccesses.add(attribute.getAttributeWithoutContext(1) + " - property " + propName + " matched, but is not valid for the object.");
                return null;
            }
            return prop.getObjectAttribute(attribute);
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyTags) {
            ObjectTag returned;
            Property prop = listGetter.get(object);
            if (prop == null || (returned = prop.getObjectAttribute(attribute)) == null) continue;
            return returned;
        }
        return null;
    }

    public static ObjectTag autoAttribTyped(ObjectTag inp, Attribute attribute) {
        return CoreUtilities.autoAttrib(CoreUtilities.fixType(inp, attribute.context), attribute);
    }

    public static ObjectTag autoAttrib(ObjectTag inp, Attribute attribute) {
        if (inp == null) {
            Debug.echoError("Tag parse failed (null return) for tag <LG><" + attribute.toString() + "<LG>><W>!");
            return null;
        }
        if (attribute.isComplete()) {
            return inp;
        }
        return inp.getObjectAttribute(attribute);
    }

    public static <T extends ObjectTag> T asType(ObjectTag inp, Class<T> type, TagContext context) {
        if (inp.getObjectTagClass() == type) {
            return (T)inp;
        }
        TagTypeConverter converter = typeConverters.get(type);
        if (converter != null) {
            return (T)converter.convert(inp, context);
        }
        return ObjectFetcher.getObjectFrom(type, inp.toString(), context);
    }

    public static void registerTypeAsNoOtherTypeCode(final Class<? extends ObjectTag> type, final String knownCode) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                if (inp == null) {
                    return false;
                }
                Class<? extends ObjectTag> inpType = inp.getObjectTagClass();
                if (inpType == type) {
                    return true;
                }
                if (inpType == ElementTag.class) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals(knownCode) || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            }
        });
    }

    public static void registerTypeAsTrueAlways(Class<? extends ObjectTag> type) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                return true;
            }
        });
    }

    public static boolean canPossiblyBeType(ObjectTag inp, Class<? extends ObjectTag> type) {
        if (inp.getObjectTagClass() == type) {
            return true;
        }
        TypeComparisonRunnable comp = typeCheckers.get(type);
        if (comp != null && !comp.canBecome(inp)) {
            return false;
        }
        return ObjectFetcher.checkMatch(type, inp.toString());
    }

    public static void deleteDirectory(File directory) throws IOException {
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyDirectory(File source, File destination, HashSet<String> excludeExtensions) throws IOException {
        CoreUtilities.copyDirectory(source.toPath(), destination.toPath(), excludeExtensions);
    }

    public static void copyDirectory(Path source, Path destination, HashSet<String> excludeExtensions) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(file -> {
            try {
                String ext;
                String name;
                int dot;
                if (excludeExtensions != null && (dot = (name = file.getFileName().toString()).indexOf(46)) >= 0 && excludeExtensions.contains(ext = CoreUtilities.toLowerCase(name.substring(dot + 1)))) {
                    return;
                }
                Files.copy(file, destination.resolve(source.relativize((Path)file)), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static Random getRandom() {
        return random;
    }

    public static String bigDecToString(BigDecimal input) {
        String temp = input.toString();
        if (CoreUtilities.contains(temp, '.')) {
            for (int i = temp.length() - 1; i >= 0; --i) {
                if (temp.charAt(i) == '0') continue;
                if (temp.charAt(i) == '.') {
                    return temp.substring(0, i);
                }
                return temp.substring(0, i + 1);
            }
        }
        return temp;
    }

    public static String doubleToString(float input) {
        if (Float.isNaN(input)) {
            return "NaN";
        }
        if (Float.isInfinite(input)) {
            if (input < 0.0f) {
                return "-infinity";
            }
            return "infinity";
        }
        return floatFormat.format(input);
    }

    public static String doubleToString(double input) {
        if (Double.isNaN(input)) {
            return "NaN";
        }
        if (Double.isInfinite(input)) {
            if (input < 0.0) {
                return "-infinity";
            }
            return "infinity";
        }
        return df.format(input);
    }

    public static List<File> listDScriptFiles(File dir) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(CoreUtilities.listDScriptFiles(file));
        }
        return files;
    }

    public static boolean contains(String str, char c) {
        return str.indexOf(c) >= 0;
    }

    public static String concat(List<String> str, String split) {
        StringBuilder sb = new StringBuilder();
        if (str.size() > 0) {
            sb.append(str.get(0));
        }
        for (int i = 1; i < str.size(); ++i) {
            sb.append(split).append(str.get(i));
        }
        return sb.toString();
    }

    public static List<String> split(String str, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
        }
        strings.add(str.substring(start));
        return strings;
    }

    public static List<String> split(String str, char c, int max) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
            if (strings.size() + 1 == max) break;
        }
        strings.add(str.substring(start));
        if (Debug.verbose) {
            Debug.log("Splitting " + str + " around " + c + " limited to " + max + " returns " + CoreUtilities.concat(strings, ":::"));
        }
        return strings;
    }

    public static boolean equalsIgnoreCase(String input, String compared) {
        int inLength = input.length();
        if (inLength != compared.length()) {
            return false;
        }
        for (int i = 0; i < inLength; ++i) {
            char a = input.charAt(i);
            char b = compared.charAt(i);
            if (a >= 'A' && a <= 'Z') {
                a = (char)(a + 32);
            }
            if (b >= 'A' && b <= 'Z') {
                b = (char)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String input) {
        int len = input.length();
        boolean any = false;
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            any = true;
            break;
        }
        if (!any) {
            return input;
        }
        char[] data = input.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 'A' || data[i] > 'Z') continue;
            int n = i;
            data[n] = (char)(data[n] - -32);
        }
        return new String(data);
    }

    public static String getXthArg(int argc, String args) {
        char[] data = args.toCharArray();
        StringBuilder nArg = new StringBuilder();
        int arg = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                if (++arg <= argc) continue;
                return nArg.toString();
            }
            if (arg != argc) continue;
            nArg.append(data[i]);
        }
        return nArg.toString();
    }

    public static boolean xthArgEquals(int argc, String args, String input) {
        char[] data = args.toCharArray();
        char[] data2 = input.toCharArray();
        int arg = 0;
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                ++arg;
                continue;
            }
            if (arg != argc) continue;
            if (x == data2.length) {
                return false;
            }
            if (data2[x++] == data[i]) continue;
            return false;
        }
        return x == data2.length;
    }

    public static String getClosestOption(List<String> strs, String opt) {
        int minDist = Integer.MAX_VALUE;
        opt = CoreUtilities.toLowerCase(opt);
        String closest = "";
        for (String cmd : strs) {
            String comp = CoreUtilities.toLowerCase(cmd);
            int distance = CoreUtilities.getLevenshteinDistance(opt, comp);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = cmd;
        }
        return closest;
    }

    public static int indexOfAny(String str, int start, char ... chars) {
        int earliest = -1;
        for (char c : chars) {
            int index = str.indexOf(c, start);
            if (index == -1 || earliest != -1 && index >= earliest) continue;
            earliest = index;
        }
        return earliest;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static byte[] hexDecode(String str) {
        byte[] output = new byte[str.length() >> 1];
        for (int i = 0; i < output.length; ++i) {
            char a = str.charAt(i << 1);
            char b = str.charAt((i << 1) + 1);
            byte valA = (byte)(valueOfHex[a] << 4);
            byte valB = valueOfHex[b];
            output[i] = (byte)(valA + valB);
        }
        return output;
    }

    public static String hexEncode(byte[] value) {
        char[] output = new char[value.length * 2];
        for (int i = 0; i < value.length; ++i) {
            byte valA = (byte)((value[i] & 0xF0) >> 4);
            byte valB = (byte)(value[i] & 0xF);
            output[i << 1] = charForByte[valA];
            output[(i << 1) + 1] = charForByte[valB];
        }
        return new String(output);
    }

    public static void journallingFileSave(String filePath, String contents) {
        File saveToFile = new File(filePath + "~1");
        try {
            saveToFile.getParentFile().mkdirs();
            Charset charset = ScriptHelper.encoding == null ? null : ScriptHelper.encoding.charset();
            FileOutputStream fiout = new FileOutputStream(saveToFile);
            OutputStreamWriter writer = charset == null ? new OutputStreamWriter(fiout) : new OutputStreamWriter((OutputStream)fiout, charset);
            writer.write(contents);
            writer.close();
            File bakFile = new File(filePath + "~2");
            File realFile = new File(filePath);
            if (realFile.exists()) {
                realFile.renameTo(bakFile);
            }
            saveToFile.renameTo(realFile);
            if (bakFile.exists()) {
                bakFile.delete();
            }
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to save data to path '" + filePath + "'");
            Debug.echoError(ex);
        }
    }

    public static String journallingLoadFile(String filePath) {
        try {
            File realPath;
            File flagFile = new File(filePath);
            if (flagFile.exists()) {
                realPath = flagFile;
            } else {
                File bakFile = new File(filePath + "~2");
                if (bakFile.exists()) {
                    realPath = bakFile;
                } else {
                    return null;
                }
            }
            FileInputStream fis = new FileInputStream(realPath);
            String str = ScriptHelper.convertStreamToString(fis);
            fis.close();
            return str;
        }
        catch (Throwable ex) {
            Debug.echoError("Failed to load data for path '" + filePath + "'");
            Debug.echoError(ex);
            return null;
        }
    }

    public static Collection<ObjectTag> objectToList(ObjectTag list, TagContext context) {
        if (list instanceof MapTag) {
            return ((MapTag)list).map.values();
        }
        if (list instanceof ListTag) {
            return ((ListTag)list).objectForms;
        }
        String raw = list.toString();
        if (raw.startsWith("map@") || raw.startsWith("[")) {
            return MapTag.valueOf((String)raw, (TagContext)context).map.values();
        }
        return ListTag.valueOf((String)raw, (TagContext)context).objectForms;
    }

    static {
        int i;
        decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        NBSP = String.valueOf('\u00a0');
        objectConversions = new ArrayList<Function<Object, ObjectTag>>();
        typeCheckers = new HashMap<Class<? extends ObjectTag>, TypeComparisonRunnable>();
        typeConverters = new HashMap<Class<? extends ObjectTag>, TagTypeConverter>();
        CoreUtilities.registerTypeAsTrueAlways(ElementTag.class);
        CoreUtilities.registerTypeAsTrueAlways(ListTag.class);
        CoreUtilities.registerTypeAsNoOtherTypeCode(CustomObjectTag.class, "custom");
        CoreUtilities.registerTypeAsNoOtherTypeCode(DurationTag.class, "d");
        CoreUtilities.registerTypeAsNoOtherTypeCode(MapTag.class, "map");
        CoreUtilities.registerTypeAsNoOtherTypeCode(QueueTag.class, "q");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ScriptTag.class, "s");
        CoreUtilities.registerTypeAsNoOtherTypeCode(TimeTag.class, "d");
        typeConverters.put(ElementTag.class, (obj, c) -> obj instanceof ElementTag ? obj : new ElementTag(obj.toString()));
        typeConverters.put(ListTag.class, ListTag::getListFor);
        typeConverters.put(MapTag.class, MapTag::getMapFor);
        random = new Random();
        scriptsFilter = (file, fileName) -> {
            if (fileName.startsWith(".")) {
                return false;
            }
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (ext.equalsIgnoreCase("DSCRIPT")) {
                Debug.echoError("Script '" + fileName + "' has invalid '.dscript' file extension.");
                Deprecations.dscriptFileExtension.warn();
                return false;
            }
            if (ext.equalsIgnoreCase("YML")) {
                Debug.echoError("Script '" + fileName + "' has legacy '.yml' file extension.");
                Deprecations.ymlFileExtension.warn();
                return true;
            }
            return ext.equalsIgnoreCase("dsc");
        };
        df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        floatFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        floatFormat.setMaximumFractionDigits(8);
        valueOfHex = new byte[256];
        charForByte = "0123456789abcdef".toCharArray();
        for (i = 0; i < 10; i = (int)((byte)(i + 1))) {
            CoreUtilities.valueOfHex[48 + i] = i;
        }
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            CoreUtilities.valueOfHex[97 + i] = (byte)(i + 10);
            CoreUtilities.valueOfHex[65 + i] = (byte)(i + 10);
        }
    }

    @FunctionalInterface
    public static interface TagTypeConverter {
        public ObjectTag convert(ObjectTag var1, TagContext var2);
    }

    public static abstract class TypeComparisonRunnable {
        public abstract boolean canBecome(ObjectTag var1);
    }
}

