/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ActionCommand
extends AbstractCommand {
    public ActionCommand() {
        this.setName("action");
        this.setSyntax("action [<action name>|...] (<npc>|...) (context:<name>|<object>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("context") && arg.matchesPrefix("context", "c")) {
                scriptEntry.addObject("context", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("actions")) {
                scriptEntry.addObject("actions", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("actions")) {
            throw new InvalidArgumentsException("Must specify a list of action names!");
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("npcs", Collections.singletonList(Utilities.getEntryNPC(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify an NPC to use!");
            }
        }
        scriptEntry.defaultObject("context", new ListTag());
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ListTag actions = (ListTag)scriptEntry.getObjectTag("actions");
        ListTag context = (ListTag)scriptEntry.getObjectTag("context");
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), actions.debug() + context.debug() + ArgumentHelper.debugList("npcs", npcs));
        }
        if (context.size() % 2 == 1) {
            context.add("null");
        }
        HashMap<String, ObjectTag> context_map = new HashMap<String, ObjectTag>();
        for (int i = 0; i < context.size(); i += 2) {
            context_map.put(context.get(i), ObjectFetcher.pickObjectFor(context.get(i + 1), scriptEntry.getContext()));
        }
        for (NPCTag npc : npcs) {
            for (String action : actions) {
                npc.action(action, Utilities.getEntryPlayer(scriptEntry), context_map);
            }
        }
    }
}

