/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.tags.core.BiomeTagBase;
import com.denizenscript.denizen.tags.core.ChunkTagBase;
import com.denizenscript.denizen.tags.core.ColorTagBase;
import com.denizenscript.denizen.tags.core.CuboidTagBase;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.tags.core.EllipsoidTagBase;
import com.denizenscript.denizen.tags.core.EnchantmentTagBase;
import com.denizenscript.denizen.tags.core.EntityTagBase;
import com.denizenscript.denizen.tags.core.InventoryTagBase;
import com.denizenscript.denizen.tags.core.ItemTagBase;
import com.denizenscript.denizen.tags.core.LocationTagBase;
import com.denizenscript.denizen.tags.core.MaterialTagBase;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.tags.core.ParseTagBase;
import com.denizenscript.denizen.tags.core.PlayerTagBase;
import com.denizenscript.denizen.tags.core.PluginTagBase;
import com.denizenscript.denizen.tags.core.PolygonTagBase;
import com.denizenscript.denizen.tags.core.ServerTagBase;
import com.denizenscript.denizen.tags.core.TextTagBase;
import com.denizenscript.denizen.tags.core.TradeTagBase;
import com.denizenscript.denizen.tags.core.WorldTagBase;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;

public class CommonRegistries {
    public static void registerMainTagHandlers() {
        new BiomeTagBase();
        new ChunkTagBase();
        new ColorTagBase();
        new CuboidTagBase();
        new EllipsoidTagBase();
        new EnchantmentTagBase();
        new EntityTagBase();
        new InventoryTagBase();
        new ItemTagBase();
        new LocationTagBase();
        new MaterialTagBase();
        if (Depends.citizens != null) {
            new NPCTagBase();
        }
        new PlayerTagBase();
        new PluginTagBase();
        new PolygonTagBase();
        new TradeTagBase();
        new WorldTagBase();
        new CustomColorTagBase();
        new ServerTagBase();
        new TextTagBase();
        new ParseTagBase();
    }

    public static void registerMainObjects() {
        CommonRegistries.registerObjectTypes();
        CommonRegistries.registerNotables();
        CommonRegistries.registerObjectCheckers();
        CommonRegistries.registerConversions();
        CommonRegistries.registerSubtypeSets();
        StringBuilder debug = new StringBuilder(256);
        for (ObjectFetcher.ObjectType<? extends ObjectTag> objectType : ObjectFetcher.objectsByPrefix.values()) {
            debug.append(objectType.clazz.getSimpleName()).append(" as ").append(objectType.prefix).append(", ");
        }
        Debug.echoApproval("Loaded core object types: [" + debug.substring(0, debug.length() - 2) + "]");
    }

    private static void registerObjectTypes() {
        ObjectFetcher.registerWithObjectFetcher(BiomeTag.class, BiomeTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ChunkTag.class, ChunkTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ColorTag.class, ColorTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(CuboidTag.class, CuboidTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(EllipsoidTag.class, EllipsoidTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(EnchantmentTag.class, EnchantmentTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(EntityTag.class, EntityTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(InventoryTag.class, InventoryTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(ItemTag.class, ItemTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(LocationTag.class, LocationTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(MaterialTag.class, MaterialTag.tagProcessor);
        if (Depends.citizens != null) {
            ObjectFetcher.registerWithObjectFetcher(NPCTag.class, NPCTag.tagProcessor);
        }
        ObjectFetcher.registerWithObjectFetcher(PlayerTag.class, PlayerTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(PluginTag.class, PluginTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(PolygonTag.class, PolygonTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(TradeTag.class, TradeTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(WorldTag.class, WorldTag.tagProcessor);
    }

    private static void registerNotables() {
        NoteManager.registerObjectTypeAsNotable(CuboidTag.class);
        NoteManager.registerObjectTypeAsNotable(EllipsoidTag.class);
        NoteManager.registerObjectTypeAsNotable(InventoryTag.class);
        NoteManager.registerObjectTypeAsNotable(ItemTag.class);
        NoteManager.registerObjectTypeAsNotable(LocationTag.class);
        NoteManager.registerObjectTypeAsNotable(PolygonTag.class);
    }

    private static void registerObjectCheckers() {
        CoreUtilities.registerTypeAsNoOtherTypeCode(BiomeTag.class, "b");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ChunkTag.class, "ch");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ColorTag.class, "co");
        CoreUtilities.registerTypeAsNoOtherTypeCode(CuboidTag.class, "cu");
        CoreUtilities.registerTypeAsNoOtherTypeCode(EllipsoidTag.class, "ellipsoid");
        CoreUtilities.registerTypeAsNoOtherTypeCode(EnchantmentTag.class, "enchantment");
        CoreUtilities.typeCheckers.put(EntityTag.class, new CoreUtilities.TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                if (inp == null) {
                    return false;
                }
                if (inp instanceof PlayerTag || inp instanceof EntityTag || inp instanceof NPCTag) {
                    return true;
                }
                if (inp instanceof ElementTag) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("e") || code.equals("p") || code.equals("n") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            }
        });
        CoreUtilities.typeCheckers.put(PlayerTag.class, new CoreUtilities.TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                if (inp == null) {
                    return false;
                }
                if (inp instanceof PlayerTag || inp instanceof EntityTag) {
                    return true;
                }
                if (inp instanceof ElementTag) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("p") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            }
        });
        CoreUtilities.typeCheckers.put(NPCTag.class, new CoreUtilities.TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                if (inp == null) {
                    return false;
                }
                if (inp instanceof NPCTag || inp instanceof EntityTag) {
                    return true;
                }
                if (inp instanceof ElementTag) {
                    String code;
                    String simple = inp.identifySimple();
                    int atIndex = simple.indexOf(64);
                    return atIndex == -1 || (code = simple.substring(0, atIndex)).equals("n") || code.equals("el") || !ObjectFetcher.objectsByPrefix.containsKey(code);
                }
                return false;
            }
        });
        CoreUtilities.typeConverters.put(EntityTag.class, (obj, context) -> {
            if (obj instanceof PlayerTag && ((PlayerTag)obj).isOnline()) {
                return new EntityTag((Entity)((PlayerTag)obj).getPlayerEntity());
            }
            if (obj instanceof NPCTag && ((NPCTag)obj).isSpawned()) {
                return new EntityTag(((NPCTag)obj).getEntity());
            }
            return EntityTag.valueOf(obj.toString(), context);
        });
        CoreUtilities.typeConverters.put(NPCTag.class, (obj, context) -> {
            if (obj instanceof EntityTag && ((EntityTag)obj).isCitizensNPC()) {
                return ((EntityTag)obj).getDenizenNPC();
            }
            return NPCTag.valueOf(obj.toString(), context);
        });
        CoreUtilities.typeConverters.put(PlayerTag.class, (obj, context) -> {
            if (obj instanceof EntityTag && ((EntityTag)obj).isPlayer()) {
                return ((EntityTag)obj).getDenizenPlayer();
            }
            return PlayerTag.valueOf(obj.toString(), context);
        });
        CoreUtilities.registerTypeAsNoOtherTypeCode(InventoryTag.class, "in");
        CoreUtilities.registerTypeAsNoOtherTypeCode(ItemTag.class, "i");
        CoreUtilities.registerTypeAsNoOtherTypeCode(LocationTag.class, "l");
        CoreUtilities.registerTypeAsNoOtherTypeCode(MaterialTag.class, "m");
        CoreUtilities.registerTypeAsNoOtherTypeCode(PluginTag.class, "pl");
        CoreUtilities.registerTypeAsNoOtherTypeCode(PolygonTag.class, "polygon");
        CoreUtilities.registerTypeAsNoOtherTypeCode(TradeTag.class, "trade");
        CoreUtilities.registerTypeAsNoOtherTypeCode(WorldTag.class, "w");
    }

    private static void registerConversions() {
        CoreUtilities.objectConversions.add(obj -> {
            if (obj instanceof Biome) {
                return new BiomeTag((Biome)obj);
            }
            if (obj instanceof Chunk) {
                return new ChunkTag((Chunk)obj);
            }
            if (obj instanceof Color) {
                return new ColorTag((Color)obj);
            }
            if (obj instanceof Enchantment) {
                return new EnchantmentTag((Enchantment)obj);
            }
            if (obj instanceof Entity) {
                return new EntityTag((Entity)obj).getDenizenObject();
            }
            if (obj instanceof Inventory) {
                return InventoryTag.mirrorBukkitInventory((Inventory)obj);
            }
            if (obj instanceof ItemStack) {
                return new ItemTag((ItemStack)obj);
            }
            if (obj instanceof Location) {
                return new LocationTag((Location)obj);
            }
            if (obj instanceof Material) {
                return new MaterialTag((Material)obj);
            }
            if (obj instanceof BlockData) {
                return new MaterialTag((BlockData)obj);
            }
            if (obj instanceof Block) {
                return new LocationTag(((Block)obj).getLocation());
            }
            if (Depends.citizens != null && obj instanceof NPC) {
                return new NPCTag((NPC)obj);
            }
            if (obj instanceof OfflinePlayer) {
                return new PlayerTag((OfflinePlayer)obj);
            }
            if (obj instanceof Plugin) {
                return new PluginTag((Plugin)obj);
            }
            if (obj instanceof MerchantRecipe) {
                return new TradeTag((MerchantRecipe)obj);
            }
            if (obj instanceof World) {
                return new WorldTag((World)obj);
            }
            return null;
        });
    }

    private static void registerSubtypeSets() {
        ArrayList<Class<NPCTag>> entitySubTypes = new ArrayList<Class<NPCTag>>();
        entitySubTypes.add(EntityTag.class);
        entitySubTypes.add(PlayerTag.class);
        if (Depends.citizens != null) {
            entitySubTypes.add(NPCTag.class);
        }
        ObjectFetcher.customSubtypeList.put(EntityTag.class, entitySubTypes);
        ObjectFetcher.customSubtypeList.put(EntityFormObject.class, entitySubTypes);
    }
}

