/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.blocks.FakeBlock;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class dChunk
implements dObject,
Adjustable {
    Chunk chunk = null;
    String prefix = "Chunk";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static dChunk valueOf(String string) {
        return dChunk.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static dChunk valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = CoreUtilities.toLowerCase(string).replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new dChunk(dWorld.valueOf(parts[2], context).getWorld().getChunkAt(Integer.valueOf(parts[0]).intValue(), Integer.valueOf(parts[1]).intValue()));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Minor: valueOf dChunk returning null: ch@" + string);
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            net.aufdemrand.denizen.utilities.debugging.dB.log("Minor: valueOf dChunk unable to handle malformed format: ch@" + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("ch@");
    }

    public dChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public dChunk(Location location) {
        this(location.getChunk());
    }

    public dLocation getCenter() {
        return new dLocation(this.getWorld(), this.getX() * 16 + 8, 128.0, this.getZ() * 16 + 8);
    }

    public int getX() {
        return this.chunk.getX();
    }

    public int getZ() {
        return this.chunk.getZ();
    }

    public World getWorld() {
        return this.chunk.getWorld();
    }

    public ChunkSnapshot getSnapshot() {
        return this.chunk.getChunkSnapshot();
    }

    public int[] getHeightMap() {
        return NMSHandler.getInstance().getChunkHelper().getHeightMap(this.chunk);
    }

    @Override
    public String getObjectType() {
        return "Chunk";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dChunk setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        dChunk.registerTag("add", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] requires two values!");
                    return null;
                }
                double x = aH.getDoubleFrom(coords.get(0)) * 16.0;
                double z = aH.getDoubleFrom(coords.get(1)) * 16.0;
                return new dChunk(((dChunk)object).getCenter().clone().add(x, 0.0, z).getChunk()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("sub", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag ch@chunk.sub[<#>,<#>] requires two values!");
                    return null;
                }
                double x = aH.getDoubleFrom(coords.get(0)) * 16.0;
                double z = aH.getDoubleFrom(coords.get(1)) * 16.0;
                return new dChunk(((dChunk)object).getCenter().clone().subtract(x, 0.0, z).getChunk()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("is_loaded", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).chunk.isLoaded()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("x", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).chunk.getX()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("z", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dChunk)object).chunk.getZ()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("world", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return dWorld.mirrorBukkitWorld(((dChunk)object).chunk.getWorld()).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("cuboid", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dChunk chunk = (dChunk)object;
                return new dCuboid(new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16)), new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 15), 255.0, (double)(chunk.getZ() * 16 + 15))).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                for (Entity ent : ((dChunk)object).chunk.getEntities()) {
                    entities.add(new dEntity(ent).identify());
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                for (Entity ent : ((dChunk)object).chunk.getEntities()) {
                    if (!(ent instanceof LivingEntity)) continue;
                    entities.add(new dEntity(ent).identify());
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList entities = new dList();
                for (Entity ent : ((dChunk)object).chunk.getEntities()) {
                    if (!dEntity.isPlayer(ent)) continue;
                    entities.add(new dEntity(ent).identify());
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("height_map", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int[] heightMap = ((dChunk)object).getHeightMap();
                ArrayList<String> height_map = new ArrayList<String>(heightMap.length);
                for (int i : heightMap) {
                    height_map.add(String.valueOf(i));
                }
                return new dList((List<String>)height_map).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("average_height", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int[] heightMap;
                int sum = 0;
                for (int i : heightMap = ((dChunk)object).getHeightMap()) {
                    sum += i;
                }
                return new Element((double)sum / (double)heightMap.length).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("is_flat", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int tolerance = attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1)) ? Integer.valueOf(attribute.getContext(1)) : 2;
                int[] heightMap = ((dChunk)object).getHeightMap();
                int x = heightMap[0];
                for (int i : heightMap) {
                    if (Math.abs(x - i) <= tolerance) continue;
                    return new Element(false).getAttribute(attribute.fulfill(1));
                }
                return new Element(true).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("surface_blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dList surface_blocks = new dList();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        surface_blocks.add(new dLocation(((dChunk)object).chunk.getBlock(x, ((dChunk)object).getSnapshot().getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                    }
                }
                return surface_blocks.getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("spawn_slimes", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dChunk chunk = (dChunk)object;
                Random random = new Random(chunk.getWorld().getSeed() + (long)(chunk.getX() * chunk.getX() * 4987142) + (long)(chunk.getX() * 5947611) + (long)(chunk.getZ() * chunk.getZ()) * 4392871L + (long)(chunk.getZ() * 389711) ^ 0x3AD8025FL);
                return new Element(random.nextInt(10) == 0).getAttribute(attribute.fulfill(1));
            }
        });
        dChunk.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Chunk").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        net.aufdemrand.denizen.utilities.debugging.dB.echoError("Cannot apply properties to a chunk!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unload")) {
            this.chunk.unload(true);
        }
        if (mechanism.matches("unload_safely")) {
            this.chunk.unload(true, true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.chunk.unload(false);
        }
        if (mechanism.matches("load")) {
            this.chunk.load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            final int chunkX = this.getX();
            final int chunkZ = this.getZ();
            this.getWorld().refreshChunk(chunkX, chunkZ);
            new BukkitRunnable(){

                public void run() {
                    for (Map<dLocation, FakeBlock> blocks : FakeBlock.getBlocks().values()) {
                        for (Map.Entry<dLocation, FakeBlock> locBlock : blocks.entrySet()) {
                            dLocation location = locBlock.getKey();
                            if (Math.floor(location.getX() / 16.0) != (double)chunkX || Math.floor(location.getZ() / 16.0) != (double)chunkZ) continue;
                            locBlock.getValue().updateBlock();
                        }
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
        }
        if (mechanism.matches("refresh_chunk_sections")) {
            NMSHandler.getInstance().getChunkHelper().refreshChunkSections(this.chunk);
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

