/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TippedArrow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityPotionEffects
implements Property {
    public static final String[] handledTags = new String[]{"list_effects", "has_effect"};
    public static final String[] handledMechs = new String[]{"potion_effects"};
    dEntity entity;

    public static boolean describes(dObject object) {
        return object instanceof dEntity && (((dEntity)object).isLivingEntity() || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && ((dEntity)object).getBukkitEntityType() == EntityType.TIPPED_ARROW);
    }

    public static EntityPotionEffects getFrom(dObject object) {
        if (!EntityPotionEffects.describes(object)) {
            return null;
        }
        return new EntityPotionEffects((dEntity)object);
    }

    private EntityPotionEffects(dEntity entity) {
        this.entity = entity;
    }

    public Collection<PotionEffect> getEffectsList() {
        if (this.entity.isLivingEntity()) {
            return this.entity.getLivingEntity().getActivePotionEffects();
        }
        if (this.entity.getBukkitEntityType() == EntityType.TIPPED_ARROW) {
            return ((TippedArrow)this.entity.getBukkitEntity()).getCustomEffects();
        }
        return new ArrayList<PotionEffect>();
    }

    @Override
    public String getPropertyString() {
        Collection<PotionEffect> effects = this.getEffectsList();
        if (effects.isEmpty()) {
            return null;
        }
        dList returnable = new dList();
        for (PotionEffect effect : effects) {
            returnable.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration());
        }
        return returnable.identify().substring(3);
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("list_effects")) {
            dList effects = new dList();
            for (PotionEffect effect : this.getEffectsList()) {
                effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration());
            }
            return effects.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_effect")) {
            boolean returnElement = false;
            if (attribute.hasContext(1)) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getContext(1));
                for (PotionEffect effect : this.getEffectsList()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    returnElement = true;
                }
            } else if (!this.getEffectsList().isEmpty()) {
                returnElement = true;
            }
            return new Element(returnElement).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            dList effects = dList.valueOf(mechanism.getValue().asString());
            for (String effect : effects) {
                PotionEffectType effectType;
                List<String> split = CoreUtilities.split(effect, ',');
                if (split.size() != 3 || (effectType = PotionEffectType.getByName((String)split.get(0))) == null) continue;
                try {
                    if (this.entity.isLivingEntity()) {
                        this.entity.getLivingEntity().addPotionEffect(new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue()));
                        continue;
                    }
                    if (this.entity.getBukkitEntityType() != EntityType.TIPPED_ARROW) continue;
                    ((TippedArrow)this.entity.getBukkitEntity()).addCustomEffect(new PotionEffect(effectType, Integer.valueOf(split.get(2)).intValue(), Integer.valueOf(split.get(1)).intValue()), true);
                }
                catch (NumberFormatException ex) {}
            }
        }
    }
}

