/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Collections;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.maps.DenizenMapManager;
import net.aufdemrand.denizen.utilities.maps.DenizenMapRenderer;
import net.aufdemrand.denizen.utilities.maps.MapAnimatedImage;
import net.aufdemrand.denizen.utilities.maps.MapCursor;
import net.aufdemrand.denizen.utilities.maps.MapDot;
import net.aufdemrand.denizen.utilities.maps.MapImage;
import net.aufdemrand.denizen.utilities.maps.MapText;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.NaturalOrderComparator;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.text.StringHolder;
import org.bukkit.map.MapView;

public class MapScriptContainer
extends ScriptContainer {
    public MapScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public void applyTo(MapView mapView) {
        DenizenMapRenderer renderer = new DenizenMapRenderer(mapView.getRenderers(), aH.getBooleanFrom(this.getString("AUTO UPDATE", "true")));
        boolean debug = true;
        if (this.contains("ORIGINAL")) {
            renderer.displayOriginal = aH.getBooleanFrom(this.getString("ORIGINAL"));
        }
        if (this.contains("DEBUG")) {
            debug = aH.getBooleanFrom(this.getString("DEBUG"));
        }
        if (this.contains("OBJECTS")) {
            YamlConfiguration objectsSection = this.getConfigurationSection("OBJECTS");
            ArrayList<StringHolder> objectKeys1 = new ArrayList<StringHolder>(objectsSection.getKeys(false));
            ArrayList<String> objectKeys = new ArrayList<String>(objectKeys1.size());
            for (StringHolder sh : objectKeys1) {
                objectKeys.add(sh.str);
            }
            Collections.sort(objectKeys, new NaturalOrderComparator());
            for (String objectKey : objectKeys) {
                boolean worldC;
                YamlConfiguration objectSection = objectsSection.getConfigurationSection(objectKey);
                if (!objectSection.contains("TYPE")) {
                    dB.echoError("Map script '" + this.getName() + "' has an object without a specified type!");
                    return;
                }
                String type = objectSection.getString("TYPE").toUpperCase();
                String x = objectSection.getString("X", "0");
                String y = objectSection.getString("Y", "0");
                String visible = objectSection.getString("VISIBLE", "true");
                boolean bl = worldC = objectSection.contains("WORLD_COORDINATES") && aH.getBooleanFrom(objectSection.getString("WORLD_COORDINATES", "false"));
                if (type.equals("IMAGE")) {
                    if (!objectSection.contains("IMAGE")) {
                        dB.echoError("Map script '" + this.getName() + "'s image '" + objectKey + "' has no specified image location!");
                        return;
                    }
                    String image = objectSection.getString("IMAGE");
                    int width = aH.getIntegerFrom(objectSection.getString("WIDTH", "0"));
                    int height = aH.getIntegerFrom(objectSection.getString("HEIGHT", "0"));
                    if (CoreUtilities.toLowerCase(image).endsWith(".gif")) {
                        renderer.addObject(new MapAnimatedImage(x, y, visible, debug, image, width, height));
                    } else {
                        renderer.addObject(new MapImage(x, y, visible, debug, image, width, height));
                    }
                } else if (type.equals("TEXT")) {
                    if (!objectSection.contains("TEXT")) {
                        dB.echoError("Map script '" + this.getName() + "'s text object '" + objectKey + "' has no specified text!");
                        return;
                    }
                    String text = objectSection.getString("TEXT");
                    renderer.addObject(new MapText(x, y, visible, debug, text));
                } else if (type.equals("CURSOR")) {
                    if (!objectSection.contains("CURSOR")) {
                        dB.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' has no specified cursor type!");
                        return;
                    }
                    String cursor = objectSection.getString("CURSOR");
                    if (cursor == null) {
                        dB.echoError("Map script '" + this.getName() + "'s cursor '" + objectKey + "' is missing a cursor type!");
                        return;
                    }
                    renderer.addObject(new MapCursor(x, y, visible, debug, objectSection.getString("DIRECTION", "0"), cursor));
                } else if (type.equals("DOT")) {
                    renderer.addObject(new MapDot(x, y, visible, debug, objectSection.getString("RADIUS", "1"), objectSection.getString("COLOR", "black")));
                } else {
                    dB.echoError("Weird map data!");
                }
                if (!worldC || renderer.mapObjects.size() <= 0) continue;
                renderer.mapObjects.get((int)(renderer.mapObjects.size() - 1)).worldCoordinates = true;
            }
        }
        DenizenMapManager.setMap(mapView, renderer);
    }
}

