/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    private static Field REGISTERED_LISTENER_EXECUTOR_FIELD;
    public HashMap<EventPriority, BukkitScriptEvent> priorityHandlers;
    public List<Map.Entry<RegisteredListener, HandlerList>> registeredHandlers;
    public Event currentEvent = null;
    public static HashSet<String> specialEntityMatchables;

    public boolean couldMatchLegacyInArea(String lower) {
        String next;
        int index = CoreUtilities.split(lower, ' ').indexOf("in");
        if (index == -1) {
            return true;
        }
        String in = CoreUtilities.getXthArg(index + 1, lower);
        if (this.couldMatchInventory(in)) {
            return false;
        }
        return !in.equals("notable") && !in.equals("noted") || (next = CoreUtilities.getXthArg(index + 2, lower)).equals("cuboid") || next.equals("ellipsoid");
    }

    public boolean couldMatchArea(String text) {
        if (text.equals("area") || text.equals("cuboid") || text.equals("polygon") || text.equals("ellipsoid")) {
            return true;
        }
        if (text.startsWith("area_flagged:") || text.startsWith("biome:")) {
            return true;
        }
        if (NoteManager.getSavedObject(text) instanceof AreaContainmentObject) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Notable obj : NoteManager.nameToObject.values()) {
                if (!(obj instanceof AreaContainmentObject) || !matcher.doesMatch(((AreaContainmentObject)((Object)obj)).getNoteName())) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid area label", text);
        return false;
    }

    public boolean exactMatchesEnum(String text, Enum<?>[] enumVals) {
        for (Enum<?> val : enumVals) {
            if (!CoreUtilities.equalsIgnoreCase(val.name(), text)) continue;
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Does not match required enumeration", text);
        return false;
    }

    public boolean couldMatchEnum(String text, Enum<?>[] enumVals) {
        if (this.exactMatchesEnum(text, enumVals)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Enum<?> val : enumVals) {
                if (!matcher.doesMatch(val.name())) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Does not match required enumeration", text);
        return false;
    }

    public boolean couldMatchInventory(String text) {
        if (text.equals("inventory") || text.equals("notable") || text.equals("note")) {
            return true;
        }
        if (text.startsWith("inventory_flagged:")) {
            return true;
        }
        if (InventoryTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (InventoryType inventoryType : InventoryType.values()) {
                if (!matcher.doesMatch(inventoryType.name())) continue;
                return true;
            }
            for (InventoryType inventoryType : InventoryTag.idTypes) {
                if (!matcher.doesMatch((String)inventoryType)) continue;
                return true;
            }
            for (String type : InventoryScriptHelper.inventoryScripts.keySet()) {
                if (!matcher.doesMatch(type)) continue;
                return true;
            }
            for (InventoryTag note : InventoryScriptHelper.notedInventories.values()) {
                if (!matcher.doesMatch(note.noteName)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid inventory label", text);
        return false;
    }

    public boolean couldMatchEntity(String text) {
        if (this.exactMatchEntity(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (EntityType entity : EntityType.values()) {
                if (!matcher.doesMatch(entity.name())) continue;
                return true;
            }
            for (String script : EntityScriptHelper.scripts.keySet()) {
                if (!matcher.doesMatch(script)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid entity label", text);
        return false;
    }

    public boolean exactMatchEntity(String text) {
        if (specialEntityMatchables.contains(text)) {
            return true;
        }
        if (text.startsWith("entity_flagged:") || text.startsWith("player_flagged:") || text.startsWith("npc_flagged:")) {
            return true;
        }
        if (EntityTag.matches(text)) {
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid entity label", text);
        return false;
    }

    public boolean exactMatchesVehicle(String text) {
        if (text.equals("vehicle")) {
            return true;
        }
        if (specialEntityMatchables.contains(text)) {
            return false;
        }
        if (text.startsWith("entity_flagged:")) {
            return true;
        }
        if (text.startsWith("player_flagged:") || text.startsWith("npc_flagged:")) {
            return false;
        }
        if (EntityTag.matches(text)) {
            EntityTag entity = EntityTag.valueOf(text, CoreUtilities.noDebugContext);
            if (entity == null) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Broken entity/vehicle reference", text);
                return false;
            }
            if (!Vehicle.class.isAssignableFrom(entity.getEntityType().getBukkitEntityType().getEntityClass())) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Entity type is not a vehicle", text);
                return false;
            }
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid vehicle label", text);
        return false;
    }

    public boolean couldMatchVehicle(String text) {
        if (this.exactMatchesVehicle(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (EntityType entity : EntityType.values()) {
                if (!matcher.doesMatch(entity.name())) continue;
                return true;
            }
            for (String script : EntityScriptHelper.scripts.keySet()) {
                if (!matcher.doesMatch(script)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid vehicle label", text);
        return false;
    }

    public boolean couldMatchBlockOrItem(String text) {
        if (text.equals("block") || text.equals("material") || text.equals("item") || text.equals("potion") || text.startsWith("item_flagged:") || text.startsWith("vanilla_tagged:")) {
            return true;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            return mat != null;
        }
        if (ItemTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!matcher.doesMatch(material.name())) continue;
                return true;
            }
            for (String item : ItemScriptHelper.item_scripts.keySet()) {
                if (!matcher.doesMatch(item)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid block or item label", text);
        return false;
    }

    public boolean couldMatchBlock(String text) {
        return this.couldMatchBlock(text, null);
    }

    public boolean couldMatchBlock(String text, Function<Material, Boolean> requirement) {
        if (text.equals("block") || text.equals("material") || text.startsWith("vanilla_tagged:")) {
            return true;
        }
        if (text.equals("item")) {
            return false;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            if (mat == null || !mat.getMaterial().isBlock()) {
                return false;
            }
            if (mat.getMaterial().isBlock() && (requirement == null || requirement.apply(mat.getMaterial()).booleanValue())) {
                return true;
            }
            BukkitScriptEvent.addPossibleCouldMatchFailReason("Material is an item not a block", text);
            return false;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!material.isBlock() || !matcher.doesMatch(material.name()) || requirement != null && !requirement.apply(material).booleanValue()) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid block label", text);
        return false;
    }

    public boolean couldMatchItem(String text) {
        if (text.equals("item") || text.equals("potion")) {
            return true;
        }
        if (text.startsWith("item_flagged:") || text.startsWith("vanilla_tagged:")) {
            return true;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            if (mat == null || !mat.getMaterial().isItem()) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Material is not an item", text);
                return false;
            }
            return true;
        }
        if (ItemTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!material.isItem() || !matcher.doesMatch(material.name())) continue;
                return true;
            }
            for (String item : ItemScriptHelper.item_scripts.keySet()) {
                if (!matcher.doesMatch(item)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid item label", text);
        return false;
    }

    public boolean nonSwitchWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        int index;
        for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("with"); ++index) {
        }
        if (index >= path.eventArgsLower.length) {
            return true;
        }
        String with = path.eventArgLowerAt(index + 1);
        return with == null || held != null && BukkitScriptEvent.tryItem(held, with);
    }

    public BukkitTagContext getTagContext(ScriptEvent.ScriptPath path) {
        BukkitTagContext context = (BukkitTagContext)this.getScriptEntryData().getTagContext().clone();
        context.script = new ScriptTag(path.container);
        context.debug = path.container.shouldDebug();
        return context;
    }

    public static Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException var3) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return BukkitScriptEvent.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public static HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = BukkitScriptEvent.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception var3) {
            throw new IllegalPluginAccessException(var3.toString());
        }
    }

    public static EventExecutor getExecutor(RegisteredListener listener) {
        try {
            return (EventExecutor)REGISTERED_LISTENER_EXECUTOR_FIELD.get(listener);
        }
        catch (IllegalAccessException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public ScriptEvent fire() {
        if (!Bukkit.isPrimaryThread()) {
            if (Debug.verbose) {
                Debug.log("Event is firing async: " + this.getName());
            }
            final BukkitScriptEvent altEvent = (BukkitScriptEvent)this.clone();
            new BukkitRunnable(){

                public void run() {
                    altEvent.fire();
                }
            }.runTask((Plugin)Denizen.getInstance());
            return altEvent;
        }
        return super.fire();
    }

    @Override
    public void cancellationChanged() {
        if (this.currentEvent instanceof Cancellable) {
            ((Cancellable)this.currentEvent).setCancelled(this.cancelled);
        }
        super.cancellationChanged();
    }

    public void fire(Event event) {
        this.currentEvent = event;
        this.cancelled = event instanceof Cancellable ? ((Cancellable)event).isCancelled() : false;
        this.fire();
    }

    @Override
    public void destroy() {
        if (this.priorityHandlers != null) {
            for (BukkitScriptEvent bukkitScriptEvent : this.priorityHandlers.values()) {
                bukkitScriptEvent.destroy();
            }
            this.priorityHandlers = null;
        }
        if (this.registeredHandlers != null) {
            for (Map.Entry entry : this.registeredHandlers) {
                ((HandlerList)entry.getValue()).unregister((RegisteredListener)entry.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        if (this instanceof Listener) {
            this.initListener((Listener)this);
        }
    }

    public void initListener(Listener listener) {
        if (this.priorityHandlers == null) {
            this.priorityHandlers = new HashMap();
        }
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String bukkitPriority = path.switches.get("bukkit_priority");
            if (bukkitPriority == null) continue;
            try {
                EventPriority priority = EventPriority.valueOf((String)bukkitPriority.toUpperCase());
                BukkitScriptEvent handler = this.priorityHandlers.get(priority);
                if (handler == null) {
                    handler = (BukkitScriptEvent)this.clone();
                    handler.eventPaths = new ArrayList();
                    handler.priorityHandlers = null;
                    handler.registeredHandlers = null;
                    this.priorityHandlers.put(priority, handler);
                    handler.initForPriority(priority, (Listener)handler);
                }
                handler.eventPaths.add(path);
                this.eventPaths.remove(path);
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                Debug.echoError(ex);
            }
        }
        if (!this.eventPaths.isEmpty()) {
            this.initForPriority(EventPriority.NORMAL, listener);
        }
    }

    public void initForPriority(EventPriority priority, Listener listener) {
        if (this.registeredHandlers == null) {
            this.registeredHandlers = new ArrayList<Map.Entry<RegisteredListener, HandlerList>>();
        }
        Denizen plugin = Denizen.getInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener(listener, BukkitScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = BukkitScriptEvent.getEventListeners(BukkitScriptEvent.getRegistrationClass((Class)entry.getKey()));
                handlers.register(newListener);
                this.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location) {
        return this.runInCheck(path, location, "in");
    }

    public boolean runFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, AbstractFlagTracker tracker) {
        String flagged = path.switches.get(switchName);
        if (flagged == null) {
            return true;
        }
        if (tracker == null) {
            return false;
        }
        for (String flag : CoreUtilities.split(flagged, '|')) {
            if (tracker.hasFlag(flag)) continue;
            return false;
        }
        return true;
    }

    public boolean runLocationFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, Location location) {
        return this.runFlaggedCheck(path, switchName, location == null ? null : new LocationTag(location).getFlagTracker());
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location, String innote) {
        if (!this.runLocationFlaggedCheck(path, "location_flagged", location)) {
            return false;
        }
        String inputText = path.switches.get(innote);
        if (inputText == null) {
            int index;
            for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals(innote); ++index) {
            }
            if (index >= path.eventArgsLower.length) {
                return true;
            }
            if (location == null) {
                return false;
            }
            Deprecations.inAreaSwitchFormat.warn();
            inputText = path.eventArgLowerAt(index + 1);
            if (inputText.equals("notable") || inputText.equals("noted")) {
                String subit = path.eventArgLowerAt(index + 2);
                if (subit.equals("cuboid")) {
                    return CuboidTag.getNotableCuboidsContaining(location).size() > 0;
                }
                if (subit.equals("ellipsoid")) {
                    return EllipsoidTag.getNotableEllipsoidsContaining(location).size() > 0;
                }
                Debug.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + path.event + "' for " + path.container.getName());
                return false;
            }
        }
        if (location == null) {
            return false;
        }
        if (inputText.startsWith("!")) {
            return !BukkitScriptEvent.inCheckInternal(this.getTagContext(path), this.getName(), location, inputText.substring(1), path.event, path.container.getName());
        }
        return BukkitScriptEvent.inCheckInternal(this.getTagContext(path), this.getName(), location, inputText, path.event, path.container.getName());
    }

    public static boolean inCheckInternal(TagContext context, String name, Location location, String inputText, String evtLine, String containerName) {
        String lower = CoreUtilities.toLowerCase(inputText);
        if (lower.contains(":")) {
            if (lower.startsWith("world_flagged:")) {
                return new WorldTag(location.getWorld()).getFlagTracker().hasFlag(inputText.substring("world_flagged:".length()));
            }
            if (lower.startsWith("chunk_flagged:")) {
                return new ChunkTag(location).getFlagTracker().hasFlag(inputText.substring("chunk_flagged:".length()));
            }
            if (lower.startsWith("area_flagged:")) {
                String flagName = inputText.substring("area_flagged:".length());
                for (CuboidTag cuboid : NoteManager.getAllType(CuboidTag.class)) {
                    if (!cuboid.isInsideCuboid(location) || !cuboid.flagTracker.hasFlag(flagName)) continue;
                    return true;
                }
                for (EllipsoidTag ellipsoid : NoteManager.getAllType(EllipsoidTag.class)) {
                    if (!ellipsoid.contains(location) || !ellipsoid.flagTracker.hasFlag(flagName)) continue;
                    return true;
                }
                for (PolygonTag polygon : NoteManager.getAllType(PolygonTag.class)) {
                    if (!polygon.doesContainLocation(location) || !polygon.flagTracker.hasFlag(flagName)) continue;
                    return true;
                }
                return false;
            }
            if (lower.startsWith("biome:")) {
                String biome = inputText.substring("biome:".length());
                return BukkitScriptEvent.runGenericCheck(biome, new LocationTag((Location)location).getBiome().name);
            }
        }
        if (lower.equals("cuboid")) {
            for (CuboidTag cuboid : NoteManager.getAllType(CuboidTag.class)) {
                if (!cuboid.isInsideCuboid(location)) continue;
                return true;
            }
            return false;
        }
        if (lower.equals("ellipsoid")) {
            for (EllipsoidTag ellipsoid : NoteManager.getAllType(EllipsoidTag.class)) {
                if (!ellipsoid.contains(location)) continue;
                return true;
            }
            return false;
        }
        if (lower.equals("polygon")) {
            for (PolygonTag polygon : NoteManager.getAllType(PolygonTag.class)) {
                if (!polygon.doesContainLocation(location)) continue;
                return true;
            }
            return false;
        }
        if (WorldTag.matches(inputText)) {
            return CoreUtilities.equalsIgnoreCase(location.getWorld().getName(), lower);
        }
        if (CuboidTag.matches(inputText)) {
            CuboidTag cuboid = CuboidTag.valueOf(inputText, context);
            if (cuboid == null || !cuboid.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid cuboid): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return cuboid.isInsideCuboid(location);
        }
        if (EllipsoidTag.matches(inputText)) {
            EllipsoidTag ellipsoid = EllipsoidTag.valueOf(inputText, context);
            if (ellipsoid == null || !ellipsoid.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid ellipsoid): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return ellipsoid.contains(location);
        }
        if (PolygonTag.matches(inputText)) {
            PolygonTag polygon = PolygonTag.valueOf(inputText, context);
            if (polygon == null || !polygon.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid polygon): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return polygon.doesContainLocation(location);
        }
        if (BukkitScriptEvent.isAdvancedMatchable(lower)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(lower);
            for (CuboidTag cuboid : NoteManager.getAllType(CuboidTag.class)) {
                if (!cuboid.isInsideCuboid(location) || !matcher.doesMatch(cuboid.noteName)) continue;
                return true;
            }
            for (EllipsoidTag ellipsoid : NoteManager.getAllType(EllipsoidTag.class)) {
                if (!ellipsoid.contains(location) || !matcher.doesMatch(ellipsoid.noteName)) continue;
                return true;
            }
            for (PolygonTag polygon : NoteManager.getAllType(PolygonTag.class)) {
                if (!polygon.doesContainLocation(location) || !matcher.doesMatch(polygon.noteName)) continue;
                return true;
            }
            return matcher.doesMatch(CoreUtilities.toLowerCase(location.getWorld().getName()));
        }
        Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] ('in:???') (did you make a typo, or forget to make a notable by that name?): '" + evtLine + "' for " + containerName);
        return false;
    }

    public static boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        return BukkitScriptEvent.runWithCheck(path, held, "with");
    }

    public static boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held, String key) {
        String with = path.switches.get(key);
        if (with != null) {
            if (CoreUtilities.equalsIgnoreCase(with, "item")) {
                return true;
            }
            if (held == null || !BukkitScriptEvent.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    public boolean runFlaggedCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return this.runFlaggedCheck(path, "flagged", player);
    }

    public boolean runFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String flagged = path.switches.get(switchName);
        if (flagged == null) {
            return true;
        }
        if (player == null) {
            return false;
        }
        for (String flag : CoreUtilities.split(flagged, '|')) {
            if (player.getFlagTracker().hasFlag(flag)) continue;
            return false;
        }
        return true;
    }

    public boolean runPermissionCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return this.runPermissionCheck(path, "permission", player);
    }

    public boolean runPermissionCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String perm = path.switches.get(switchName);
        if (perm == null) {
            return true;
        }
        if (player == null || !player.isOnline()) {
            return false;
        }
        for (String permName : CoreUtilities.split(perm, '|')) {
            if (player.getPlayerEntity().hasPermission(permName)) continue;
            return false;
        }
        return true;
    }

    public boolean runAutomaticPlayerSwitches(ScriptEvent.ScriptPath path) {
        if (!path.switches.containsKey("flagged") && !path.switches.containsKey("permission")) {
            return true;
        }
        BukkitScriptEntryData data = (BukkitScriptEntryData)this.getScriptEntryData();
        if (!data.hasPlayer()) {
            return false;
        }
        if (!this.runFlaggedCheck(path, data.getPlayer())) {
            return false;
        }
        return this.runPermissionCheck(path, data.getPlayer());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runAutomaticPlayerSwitches(path)) {
            return false;
        }
        return super.matches(path);
    }

    public static boolean tryWorld(WorldTag world, String comparedto) {
        if (comparedto.equals("world")) {
            return true;
        }
        if (comparedto.startsWith("world_flagged:")) {
            return world.getFlagTracker().hasFlag(comparedto.substring("world_flagged:".length()));
        }
        return BukkitScriptEvent.runGenericCheck(comparedto, world.getName());
    }

    public static boolean compareInventoryToMatch(InventoryTag inv, ScriptEvent.MatchHelper matcher) {
        if (matcher instanceof ScriptEvent.InverseMatchHelper) {
            return !BukkitScriptEvent.compareInventoryToMatch(inv, ((ScriptEvent.InverseMatchHelper)matcher).matcher);
        }
        if (matcher.doesMatch(inv.getInventoryType().name())) {
            return true;
        }
        if (matcher.doesMatch(inv.getIdType())) {
            return true;
        }
        if (matcher.doesMatch(inv.getIdHolder().toString())) {
            return true;
        }
        if (inv.getIdHolder() instanceof ScriptTag && matcher.doesMatch(((ScriptTag)inv.getIdHolder()).getName())) {
            return true;
        }
        String notedId = NoteManager.getSavedId(inv);
        return notedId != null && matcher.doesMatch(notedId);
    }

    public static boolean tryInventory(InventoryTag inv, String comparedto) {
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("inventory")) {
            return true;
        }
        if (comparedto.equals("notable") || comparedto.equals("note")) {
            return NoteManager.isSaved(inv);
        }
        if (comparedto.startsWith("inventory_flagged:")) {
            return inv.flagTracker != null && inv.flagTracker.hasFlag(comparedto.substring("inventory_flagged:".length()));
        }
        ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(comparedto);
        return BukkitScriptEvent.compareInventoryToMatch(inv, matcher);
    }

    public static boolean tryItem(ItemTag item, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || item == null) {
            return false;
        }
        String rawComparedTo = comparedto;
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).contains(":")) {
            if (comparedto.startsWith("item_flagged:")) {
                for (String flag : CoreUtilities.split(rawComparedTo.substring("item_flagged:".length()), '|')) {
                    if (item.getFlagTracker().hasFlag(flag)) continue;
                    return false;
                }
                return true;
            }
            if (comparedto.startsWith("item_enchanted:")) {
                String enchMatcher = comparedto.substring("item_enchanted:".length());
                if (!item.getItemMeta().hasEnchants()) {
                    return false;
                }
                for (Enchantment enchant : item.getItemMeta().getEnchants().keySet()) {
                    if (!BukkitScriptEvent.runGenericCheck(enchMatcher, enchant.getKey().getKey())) continue;
                    return true;
                }
                return false;
            }
            if (comparedto.startsWith("raw_exact:")) {
                ItemTag compareItem = ItemTag.valueOf(rawComparedTo.substring("raw_exact:".length()), CoreUtilities.errorButNoDebugContext);
                return compareItem != null && compareItem.matchesRawExact(item);
            }
            if (comparedto.startsWith("vanilla_tagged:")) {
                String tagCheck = comparedto.substring("vanilla_tagged:".length());
                HashSet<String> tags = VanillaTagHelper.tagsByMaterial.get(item.getItemStack().getType());
                if (tags == null) {
                    return false;
                }
                ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(tagCheck);
                for (String tag : tags) {
                    if (!matcher.doesMatch(tag)) continue;
                    return true;
                }
                return false;
            }
            if (comparedto.startsWith("material_flagged:")) {
                return item.getMaterial().getFlagTracker().hasFlag(comparedto.substring("material_flagged:".length()));
            }
        }
        if (comparedto.equals("item")) {
            return true;
        }
        if (comparedto.equals("potion") && CoreUtilities.toLowerCase(item.getBukkitMaterial().name()).contains("potion")) {
            return true;
        }
        ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(comparedto);
        return item.isItemscript() ? matcher.doesMatch(item.getScriptName()) : matcher.doesMatch(item.getMaterialName());
    }

    public static boolean tryMaterial(MaterialTag mat, String comparedto) {
        return BukkitScriptEvent.tryMaterial(mat.getMaterial(), comparedto);
    }

    public static boolean tryMaterial(Material mat, String comparedto) {
        ScriptEvent.MatchHelper matcher;
        MaterialTag quickOf;
        if (comparedto == null || comparedto.isEmpty() || mat == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("block") || comparedto.equals("material")) {
            return true;
        }
        if (comparedto.contains(":")) {
            if (comparedto.startsWith("vanilla_tagged:")) {
                String tagCheck = comparedto.substring("vanilla_tagged:".length());
                HashSet<String> tags = VanillaTagHelper.tagsByMaterial.get(mat);
                if (tags == null) {
                    return false;
                }
                ScriptEvent.MatchHelper matcher2 = BukkitScriptEvent.createMatcher(tagCheck);
                for (String tag : tags) {
                    if (!matcher2.doesMatch(tag)) continue;
                    return true;
                }
                return false;
            }
            if (comparedto.startsWith("material_flagged:")) {
                return new MaterialTag(mat).getFlagTracker().hasFlag(comparedto.substring("material_flagged:".length()));
            }
        }
        if ((quickOf = MaterialTag.quickOfNamed(comparedto)) != null) {
            if (quickOf.getMaterial() != mat) {
                return false;
            }
            if (quickOf.getMaterial().equals((Object)mat)) {
                return true;
            }
        }
        return (matcher = BukkitScriptEvent.createMatcher(comparedto)).doesMatch(mat.name());
    }

    public static boolean tryEntity(EntityTag entity, String comparedto) {
        ScriptEvent.MatchHelper matcher;
        if (comparedto == null || comparedto.isEmpty() || entity == null) {
            return false;
        }
        Entity bEntity = entity.getBukkitEntity();
        if (specialEntityMatchables.contains(comparedto = CoreUtilities.toLowerCase(comparedto))) {
            switch (comparedto) {
                case "entity": {
                    return true;
                }
                case "npc": {
                    return entity.isCitizensNPC();
                }
                case "player": {
                    return entity.isPlayer();
                }
                case "living": {
                    return bEntity instanceof LivingEntity;
                }
                case "vehicle": {
                    return bEntity instanceof Vehicle;
                }
                case "fish": {
                    return bEntity instanceof Fish;
                }
                case "projectile": {
                    return bEntity instanceof Projectile;
                }
                case "hanging": {
                    return bEntity instanceof Hanging;
                }
                case "monster": {
                    return bEntity instanceof Monster;
                }
                case "mob": {
                    return bEntity instanceof Mob;
                }
                case "animal": {
                    return bEntity instanceof Animals;
                }
            }
        }
        if (comparedto.contains(":")) {
            if (comparedto.startsWith("entity_flagged:")) {
                return entity.getFlagTracker().hasFlag(comparedto.substring("entity_flagged:".length()));
            }
            if (comparedto.startsWith("player_flagged:")) {
                return entity.isPlayer() && entity.getFlagTracker().hasFlag(comparedto.substring("player_flagged:".length()));
            }
            if (comparedto.startsWith("npc_flagged:")) {
                return entity.isCitizensNPC() && entity.getFlagTracker().hasFlag(comparedto.substring("npc_flagged:".length()));
            }
        }
        if ((matcher = BukkitScriptEvent.createMatcher(comparedto)) instanceof ScriptEvent.InverseMatchHelper) {
            matcher = ((ScriptEvent.InverseMatchHelper)matcher).matcher;
            if (entity.getEntityScript() != null && matcher.doesMatch(entity.getEntityScript())) {
                return false;
            }
            return !matcher.doesMatch(entity.getEntityType().getLowercaseName());
        }
        if (entity.getEntityScript() != null && matcher.doesMatch(entity.getEntityScript())) {
            return true;
        }
        return matcher.doesMatch(entity.getEntityType().getLowercaseName());
    }

    static {
        try {
            REGISTERED_LISTENER_EXECUTOR_FIELD = RegisteredListener.class.getDeclaredField("executor");
            REGISTERED_LISTENER_EXECUTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Debug.echoError(ex);
        }
        specialEntityMatchables = new HashSet<String>(Arrays.asList("entity", "npc", "player", "living", "vehicle", "fish", "projectile", "hanging", "monster", "mob", "animal"));
    }
}

