/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class GotoCommand
extends AbstractCommand {
    public GotoCommand() {
        this.setName("goto");
        this.setSyntax("goto [<name>]");
        this.setRequiredArguments(1, 1);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("m_name")) {
                scriptEntry.addObject("m_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("m_name")) {
            throw new InvalidArgumentsException("Must have a mark name!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag mName = scriptEntry.getElement("m_name");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), mName);
        }
        String markName = mName.asString();
        boolean hasmark = false;
        for (int i = 0; i < scriptEntry.getResidingQueue().getQueueSize(); ++i) {
            ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(i);
            List<String> args = entry.getOriginalArguments();
            if (!CoreUtilities.equalsIgnoreCase(entry.getCommandName(), "mark") || args.size() <= 0 || !CoreUtilities.equalsIgnoreCase(args.get(0), markName)) continue;
            hasmark = true;
            break;
        }
        if (hasmark) {
            while (scriptEntry.getResidingQueue().getQueueSize() > 0) {
                ScriptEntry entry = scriptEntry.getResidingQueue().getEntry(0);
                List<String> args = entry.getOriginalArguments();
                if (!CoreUtilities.equalsIgnoreCase(entry.getCommandName(), "mark") || args.size() <= 0 || !CoreUtilities.equalsIgnoreCase(args.get(0), markName)) {
                    scriptEntry.getResidingQueue().removeEntry(0);
                    continue;
                }
                break;
            }
        } else {
            Debug.echoError(scriptEntry.getResidingQueue(), "Cannot go to that location - doesn't seem to exist!");
        }
    }
}

