/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bukkit.Material;

public class ItemCooldownCommand
extends AbstractCommand {
    public ItemCooldownCommand() {
        this.setName("itemcooldown");
        this.setSyntax("itemcooldown [<material>|...] (duration:<duration>)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Material material : Material.values()) {
            if (!material.isItem()) continue;
            addOne.accept(material.name());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("materials") && (arg.matchesArgumentType(MaterialTag.class) || arg.matchesArgumentType(ListTag.class))) {
                scriptEntry.addObject("materials", arg.asType(ListTag.class).filter(MaterialTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("d", "duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("materials")) {
            throw new InvalidArgumentsException("Missing materials argument!");
        }
        scriptEntry.defaultObject("duration", new DurationTag(1));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ArrayList materials = (ArrayList)scriptEntry.getObject("materials");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        if (player == null) {
            Debug.echoError("Invalid linked player.");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ItemCooldownCommand.db("materials", materials) + duration.debug());
        }
        for (MaterialTag mat : materials) {
            player.getPlayerEntity().setCooldown(mat.getMaterial(), duration.getTicksAsInt());
        }
    }
}

