/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class TitleCommand
extends AbstractCommand {
    public TitleCommand() {
        this.setName("title");
        this.setSyntax("title (title:<text>) (subtitle:<text>) (fade_in:<duration>/{1s}) (stay:<duration>/{3s}) (fade_out:<duration>/{1s}) (targets:<player>|...) (per_player)");
        this.setRequiredArguments(1, 7);
        this.setParseArgs(false);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : ArgumentHelper.interpret(scriptEntry, scriptEntry.getOriginalArguments())) {
            String argStr;
            if (arg.matchesPrefix("title")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("subtitle")) {
                scriptEntry.addObject("subtitle", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("fade_in")) {
                argStr = TagManager.tag(arg.getValue(), scriptEntry.getContext());
                scriptEntry.addObject("fade_in", DurationTag.valueOf(argStr, scriptEntry.context));
                continue;
            }
            if (arg.matchesPrefix("stay")) {
                argStr = TagManager.tag(arg.getValue(), scriptEntry.getContext());
                scriptEntry.addObject("stay", DurationTag.valueOf(argStr, scriptEntry.context));
                continue;
            }
            if (arg.matchesPrefix("fade_out")) {
                argStr = TagManager.tag(arg.getValue(), scriptEntry.getContext());
                scriptEntry.addObject("fade_out", DurationTag.valueOf(argStr, scriptEntry.context));
                continue;
            }
            if (arg.matchesPrefix("targets", "target")) {
                scriptEntry.addObject("targets", ListTag.getListFor(TagManager.tagObject(arg.getValue(), scriptEntry.getContext()), scriptEntry.getContext()).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("per_player") && arg.matches("per_player")) {
                scriptEntry.addObject("per_player", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("title") && !scriptEntry.hasObject("subtitle")) {
            throw new InvalidArgumentsException("Must have a title or subtitle!");
        }
        scriptEntry.defaultObject("fade_in", new DurationTag(1)).defaultObject("stay", new DurationTag(3)).defaultObject("fade_out", new DurationTag(1)).defaultObject("targets", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry))).defaultObject("subtitle", new ElementTag("")).defaultObject("title", new ElementTag(""));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String title = scriptEntry.getElement("title").asString();
        String subtitle = scriptEntry.getElement("subtitle").asString();
        DurationTag fade_in = (DurationTag)scriptEntry.getObjectTag("fade_in");
        DurationTag stay = (DurationTag)scriptEntry.getObjectTag("stay");
        DurationTag fade_out = (DurationTag)scriptEntry.getObjectTag("fade_out");
        List targets = (List)scriptEntry.getObject("targets");
        ElementTag perPlayerObj = scriptEntry.getElement("per_player");
        boolean perPlayer = perPlayerObj != null && perPlayerObj.asBoolean();
        BukkitTagContext context = (BukkitTagContext)scriptEntry.getContext();
        if (!perPlayer) {
            title = TagManager.tag(title, context);
            subtitle = TagManager.tag(subtitle, context);
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), TitleCommand.db("title", title) + TitleCommand.db("subtitle", subtitle) + fade_in.debug() + stay.debug() + fade_out.debug() + TitleCommand.db("targets", targets) + (perPlayerObj != null ? perPlayerObj.debug() : ""));
        }
        for (PlayerTag player : targets) {
            if (player != null) {
                if (!player.isOnline()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't send title to them. Skipping.");
                    continue;
                }
                String personalTitle = title;
                String personalSubtitle = subtitle;
                if (perPlayer) {
                    context.player = player;
                    personalTitle = TagManager.tag(personalTitle, context);
                    personalSubtitle = TagManager.tag(personalSubtitle, context);
                }
                NMSHandler.getPacketHelper().showTitle(player.getPlayerEntity(), personalTitle, personalSubtitle, fade_in.getTicksAsInt(), stay.getTicksAsInt(), fade_out.getTicksAsInt());
                continue;
            }
            Debug.echoError("Sent title to non-existent player!?");
        }
    }
}

