/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import io.papermc.paper.event.player.PlayerTradeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerTradesWithMerchantScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerTradesWithMerchantScriptEvent instance;
    public PlayerPurchaseEvent event;

    public PlayerTradesWithMerchantScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player trades with merchant");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (path.switches.containsKey("result") && !PlayerTradesWithMerchantScriptEvent.tryItem((ItemTag)new ItemTag(this.event.getTrade().getResult()), (String)((String)path.switches.get("result")))) {
            return false;
        }
        return super.matches(path);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(TradeTag.class)) {
            this.event.setTrade(((TradeTag)determinationObj.asType(TradeTag.class, (TagContext)this.getTagContext(path))).getRecipe());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public String getName() {
        return "PlayerTradesWithMerchant";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        if (name.equals("merchant") && this.event instanceof PlayerTradeEvent) {
            return new EntityTag((Entity)((PlayerTradeEvent)this.event).getVillager());
        }
        if (name.equals("trade")) {
            return new TradeTag(this.event.getTrade()).duplicate();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerTradeEvent(PlayerPurchaseEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

