/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;

public class EntityBreaksHangingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityBreaksHangingScriptEvent instance;
    public ElementTag cause;
    public EntityTag breaker;
    public EntityTag hanging;
    public LocationTag location;
    public HangingBreakByEntityEvent event;
    public static HashSet<String> notRelevantBreakables;

    public EntityBreaksHangingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("breaks")) {
            return false;
        }
        if (notRelevantBreakables.contains(path.eventArgLowerAt(2))) {
            return false;
        }
        if (!this.couldMatchEntity(path.eventArgLowerAt(0))) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String entName = path.eventArgLowerAt(0);
        String hang = path.eventArgLowerAt(2);
        if (!EntityBreaksHangingScriptEvent.tryEntity(this.breaker, entName)) {
            return false;
        }
        if (!hang.equals("hanging") && !EntityBreaksHangingScriptEvent.tryEntity(this.hanging, hang)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("because") && !path.eventArgLowerAt(4).equals(CoreUtilities.toLowerCase(this.cause.asString()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityBreaksHanging";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.breaker);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "cause": {
                return this.cause;
            }
            case "entity": {
                Deprecations.entityBreaksHangingEventContext.warn();
                return this.breaker;
            }
            case "breaker": {
                return this.breaker;
            }
            case "hanging": {
                return this.hanging;
            }
            case "location": {
                return this.location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakByEntityEvent event) {
        this.hanging = new EntityTag((Entity)event.getEntity());
        this.cause = new ElementTag(event.getCause().name());
        this.location = new LocationTag(this.hanging.getLocation());
        this.breaker = new EntityTag(event.getRemover());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        notRelevantBreakables = new HashSet<String>(Arrays.asList("item", "held", "block"));
    }
}

